% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bi_legend.R
\name{bi_legend}
\alias{bi_legend}
\title{Create Object for Drawing Legend}
\usage{
bi_legend(pal, dim = 3, xlab, ylab, size)
}
\arguments{
\item{pal}{A palette name; one of \code{"Brown"}, \code{"DkBlue"},
\code{"DkCyan"}, \code{"DkViolet"}, or \code{"GrPink"}.}

\item{dim}{The dimensions of the palette, either \code{2} for a two-by-two palette or
\code{3} for a three-by-three palette.}

\item{xlab}{Text for desired x axis label on legend}

\item{ylab}{Text for desired y axis label on legend}

\item{size}{Size of axis labels}
}
\value{
A \code{ggplot} object with a bivariate legend.
}
\description{
Creates a \code{ggplot} object containing a legend that is specific
    to bivariate mapping.
}
\examples{
# construct 2x2 legend
legend <- bi_legend(pal = "GrPink",
                    dim = 2,
                    xlab = "Higher \% White ",
                    ylab = "Higher Income ",
                    size = 16)

# print legend
legend

# construct 3x3 legend
legend <- bi_legend(pal = "GrPink",
                    dim = 3,
                    xlab = "Higher \% White ",
                    ylab = "Higher Income ",
                    size = 16)

# print legend
legend

}
