% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_mean.R
\encoding{UTF-8}
\name{geom_mean}
\alias{geom_mean}
\title{Geometric Mean}
\usage{
geom_mean(x, add0.001 = FALSE, ignore_neg = FALSE, ...)
}
\arguments{
\item{x}{a numeric vector or an R object which is coercible to one by as.vector(x, "numeric”).}

\item{add0.001}{logical. Should a small constant (0.001) be added to avoid issues with zeroes?}

\item{ignore_neg}{logical. Should negative values be ignored to avoid NaNs?}

\item{\dots}{further arguments passed to \code{\link{mean}}.}
}
\description{
Computes the geometric mean of a vector, \code{x}. It is a wrapper for \code{exp(mean(log(x)))}.
}
\examples{
geom_mean(1:10)
geom_mean(0:10)
geom_mean(0:10, add0.001 = TRUE)
geom_mean(-10:10, add0.001 = TRUE, ignore_neg = TRUE)

}
\author{
Matthew A. Birk, \email{matthewabirk@gmail.com}
}
\seealso{
\code{\link{mean}}
}

