% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/words.R
\name{word_bigrams}
\alias{word_bigrams}
\title{Retrieve word bigrams}
\usage{
word_bigrams(key, words, use_canonical = FALSE, min_wlmi = 0, limit = 5,
  ...)
}
\arguments{
\item{key}{a Wordnik API key. These can be obtained
at the \href{http://developer.wordnik.com/}{Wordnik developer portal}.}

\item{words}{a vector of words.}

\item{use_canonical}{whether to use the stemmed, canonical form of the word
(i.e. 'cat', for 'cats') instead of the actual \code{word}. FALSE by default.
Note that for pronunciations specifically, setting it to TRUE may get a wider
range of pronunciations; you should experiment.}

\item{min_wlmi}{the minimum (word-length weighted) strength of the similarity
between the bigram words.}

\item{limit}{the maximum number of items to return for any one word.}

\item{...}{further arguments to pass to httr's GET.}
}
\value{
a data.frame of 5 columns; \code{word}, \code{first_gram},
\code{second_gram}, \code{mi} (the strength of the relationship) and
\code{wlmi} (the strength of the relationship, weighted by word length).
}
\description{
\code{word_bigrams} grabs bigrams for whatever words you want
out of the wordnik database, along with the match strength (weighted
with and without factoring in word length).
}
\examples{
\dontrun{

dog_associations <- word_bigrams(key = "madeupkey", words = "dog")
#mauling and fighting. But also biscuits!
}
}
