% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funcs.R
\name{samples}
\alias{samples}
\title{Aesthetics for biplot samples}
\usage{
samples (bp,  col = ez.col, pch = 3, cex = 1, label = FALSE,
label.cex = 0.75, label.side = "bottom", connected = FALSE, alpha = 1)
}
\arguments{
\item{bp}{an object of class \code{biplot}.}

\item{col}{sample colour, with default \code{blue}.}

\item{pch}{sample plotting character, with default \code{+}.}

\item{cex}{sample character expansion, with default \code{1}.}

\item{label}{logical, whether samples should be labelled or not, with default \code{FALSE}.}

\item{label.cex}{label text expansion, with default \code{0.75}.}

\item{label.side}{side of the plotting character where label appears, with default \code{bottom}.}

\item{connected}{logical, whether samples are connected in order of rows of data matrix, with default \code{FALSE}.}

\item{alpha}{opacity of sample plotting character, default is \code{1}.}
}
\value{
A list with the following components is available:
\item{col}{colour of the samples.}
\item{pch}{plotting character of the samples.}
\item{cex}{expansion of the plotting character of the samples.}
\item{label}{TRUE or FALSE, whether samples should be labelled.}
\item{label.cex}{expansion of the label.}
\item{label.side}{side at which to plot the label of samples.}
\item{connected}{TRUE or FALSE, whether samples should be connected in row order of X. (not in current version)}
\item{alpha}{opacity of the samples. (not in current version)}
\item{g}{number of groups.}
}
\description{
This function allows formatting changes to samples.
}
\examples{
biplot(iris[,1:4]) |> PCA() |> samples(col="purple",pch=15) |> plot()
}
