% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seq_biological_operations.R
\name{seq_translate}
\alias{seq_translate}
\title{Translate DNA/RNA sequences into amino acids}
\usage{
seq_translate(x, code = 1, codon_frame = 1, codon_init = FALSE)
}
\arguments{
\item{x}{a vector of DNA (bioseq_dna) or RNA (bioseq_rna).}

\item{code}{an integer indicating the genetic code to use for translation
(default 1 uses the Standard genetic code). See Details.}

\item{codon_frame}{an integer giving the nucleotide position
where to start translation.}

\item{codon_init}{a logical indicating whether the first codon is evaluated
as a possible codon start and translated to methionine.}
}
\value{
An amino acid vector (\code{bioseq_aa}).
}
\description{
Translate DNA/RNA sequences into amino acids
}
\details{
Several genetic codes can be used for translation. See \link{genetic-codes}
to get the list of available genetic codes and their ID number.

Gaps (-) are interpreted as unknown nucleotides (N) but can be
removed prior to the translation with the function \code{seq_remove_gap}.

The function deals with ambiguities on both sides.
This means that if ambiguous codons cannot
be translated to amino acid, they are translated to
the most specific ambiguous amino acids
(X in the most extreme case).
}
\examples{
x <- dna(c("ATGCAGA", "GGR","TTGCCTAGKTGAACC", "AGGNGC", "NNN"))
seq_translate(x)

}
\seealso{
Other biological operations: \code{\link{rev_complement}},
  \code{\link{seq_rev_translate}},
  \code{\link{transcription}}
}
\concept{biological operations}
