% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seq_summarize_operations.R
\name{seq_consensus}
\alias{seq_consensus}
\title{Find a consensus sequence for a set of sequences.}
\usage{
seq_consensus(x, method = "chr_majority", weights = NULL,
  gaps = TRUE)
}
\arguments{
\item{x}{a DNA, RNA or AA vector.}

\item{method}{the consensus method (see Details).}

\item{weights}{an optional numeric vector of same length
as \code{x} giving a weight for each input sequence.}

\item{gaps}{logical. Should the gaps ("-") taken into account.}
}
\value{
A consensus sequence
}
\description{
Find a consensus sequence for a set of sequences.
}
\details{
"chr_majority", "chr_ambiguity", "seq_centrality", "seq_majority"

For chr_ambiguity gap character always override other characters.
Use gaps = FALSE to ignore gaps.
}
\examples{
x <- c("-----TACGCAGTAAAAGCTACTGATG",
       "CGTCATACGCAGTAAAAACTACTGATG",
       "CTTCATACGCAGTAAAAACTACTGATG",
       "CTTCATATGCAGTAAAAACTACTGATG",
       "CTTCATACGCAGTAAAAACTACTGATG",
       "CGTCATACGCAGTAAAAGCTACTGATG",
       "CTTCATATGCAGTAAAAGCTACTGACG")
x <- dna(x)
seq_consensus(x)
}
\seealso{
Other aggregation operations: \code{\link{seq_cluster}}
}
\concept{aggregation operations}
