% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logltest.R
\name{logl_test}
\alias{logl_test}
\title{Log-likelihood test for comparing terms in ASReml-R models}
\usage{
logl_test(
  model.obj,
  rand.terms = NULL,
  resid.terms = NULL,
  decimals = 3,
  numeric = FALSE,
  quiet = FALSE
)
}
\arguments{
\item{model.obj}{An ASReml-R model object}

\item{rand.terms}{Random terms from the model. Default is NULL.}

\item{resid.terms}{Residual terms from the model. Default is NULL.}

\item{decimals}{Controls rounding of decimal places in output. Default is 3 decimal places.}

\item{numeric}{Return p-values as numeric? Default is that they are characters, where very small values shown as less than a small number. See \code{details} for more.}

\item{quiet}{Logical (default: \code{FALSE}). Hide warnings and messages?}
}
\value{
A dataframe containing the results of the test.
}
\description{
Log-likelihood test for comparing terms in ASReml-R models
}
\details{
Typically p-values cannot be 0, and are usually just below some threshold of accuracy in calculation of probability.
}
\examples{
\dontrun{
library(asreml)
dat <- asreml::oats
dat <- dat[order(dat$Row, dat$Column),]

#Fit ASReml Model
model.asr <- asreml(yield ~ Nitrogen + Variety + Nitrogen:Variety,
                    random = ~ Blocks + Blocks:Wplots,
                    residual = ~ ar1(Row):ar1(Column),
                    data = dat)
oats.logl <- logl_test(
  model.obj = model.asr, rand.terms = c("Blocks", "Blocks:Wplots"),
  resid.terms = c("ar1(Row)", "ar1(Column)")
)
oats.logl
}

}
