% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variogram.r
\name{variogram}
\alias{variogram}
\title{Variogram plots for spatial models.}
\usage{
variogram(
  model.obj,
  row = NA,
  column = NA,
  horizontal = TRUE,
  palette = "default"
)
}
\arguments{
\item{model.obj}{An \code{asreml} model object.}

\item{row}{A row variable.}

\item{column}{A column variable.}

\item{horizontal}{Logical (default \code{TRUE}). The direction the plots are arranged. The default \code{TRUE} places the plots above and below, while \code{FALSE} will place them side by side.}

\item{palette}{A string specifying the colour scheme to use for plotting. The default value (\code{"default"}) is equivalent to \code{"rainbow"}. Colour blind friendly palettes can also be provided via options \code{"colour blind"} (or \code{"color blind"}, both equivalent to \code{"viridis"}), \code{"magma"}, \code{"inferno"}, \code{"plasma"} or \code{"cividis"}. The \code{"Spectral"} palette from \code{\link[scales:brewer_pal]{scales::brewer_pal()}} is also possible.}
}
\value{
A ggplot2 object.
}
\description{
Produces variogram plots for checking spatial trends.
}
\examples{
\dontrun{
library(asreml)
oats <- asreml::oats
oats <- oats[order(oats$Row, oats$Column),]
model.asr <- asreml(yield ~ Nitrogen + Variety + Nitrogen:Variety,
                    random = ~ Blocks + Blocks:Wplots,
                    residual = ~ ar1(Row):ar1(Column),
                    data = oats)
variogram(model.asr)
}
}
\references{
S. P. Kaluzny, S. C. Vega, T. P. Cardoso, A. A. Shelly, "S+SpatialStats: User’s Manual for Windows® and UNIX®" \emph{Springer New York}, 2013, p. 68, https://books.google.com.au/books?id=iADkBwAAQBAJ.

A. R. Gilmour, B. R. Cullis, A. P. Verbyla, "Accounting for Natural and Extraneous Variation in the Analysis of Field Experiments." \emph{Journal of Agricultural, Biological, and Environmental Statistics 2, no. 3}, 1997, pp. 269–93, https://doi.org/10.2307/1400446.
}
