% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getSet.R
\name{getCollectionSet}
\alias{getCollectionSet}
\title{Retrieve a Collection: Genome, Proteome, CDS, RNA, GFF, Repeat Masker, AssemblyStats of multiple species}
\usage{
getCollectionSet(
  db = "refseq",
  organisms,
  reference = FALSE,
  release = NULL,
  skip_bacteria = TRUE,
  gunzip = TRUE,
  update = FALSE,
  remove_annotation_outliers = TRUE,
  path = "set_collections",
  mute_citation = FALSE
)
}
\arguments{
\item{db}{a character string specifying the database from which the genome
shall be retrieved:
\itemize{
\item \code{db = "refseq"}
\item \code{db = "genbank"}
\item \code{db = "ensembl"}
}}

\item{organisms}{a character vector storing the names of the organisms than shall be retrieved.
There are three available options to characterize an organism:}

\item{reference}{a logical value indicating whether or not a genome shall be downloaded if it isn't marked in the database as either a reference genome or a representative genome.}

\item{release}{a numeric, the database release version of ENSEMBL (\code{db = "ensembl"}). Default is \code{release = NULL} meaning
that the most recent database version is used. \code{release = 75} would for human would give the stable
GRCh37 release in ensembl. Value must be > 46, since ensembl did not structure their data
if the standard format before that.}

\item{skip_bacteria}{Due to its enormous dataset size (> 700MB as of July 2023),
the bacterial summary file will not be loaded by default anymore. If users
wish to gain insights for the bacterial kingdom they needs to actively specify \code{skip_bacteria = FALSE}. When \code{skip_bacteria = FALSE} is set then the
bacterial summary file will be downloaded.}

\item{gunzip}{a logical, indicating whether or not files should be unzipped.}

\item{update}{logical, default FALSE. Updated backend cached files needed.
Usually keep this false, to make ut run much faster. Only set to TRUE, if you
believe you cache is outdated (Species only exist in newest release etc)}

\item{remove_annotation_outliers}{shall outlier lines be removed from the input \code{annotation_file}?
If yes, then the initial \code{annotation_file} will be overwritten and the removed outlier lines will be stored at \code{\link{tempdir}}
for further exploration.}

\item{path}{a character string specifying the location (a folder) in which
the corresponding collection shall be stored. Default is
\code{path} = \code{file.path("_db_downloads","collections")}.}

\item{mute_citation}{logical, default FALSE, indicating whether citation message should be muted.}
}
\value{
File path to downloaded genomes
(names are identifiers: 'new' (file was downloaded now),
'old' files did already exist)
}
\description{
Main collection retrieval function for an organism of interest.
By specifying the scientific name of an organism of interest a collection consisting of
the genome file, proteome file, CDS file, RNA file, GFF file, Repeat Masker file, AssemblyStats
file of the organism of interest
can be downloaded and stored locally. Collections can be retrieved from
several databases.
}
\details{
Internally this function loads the the overview.txt file from NCBI:

 refseq: ftp://ftp.ncbi.nlm.nih.gov/genomes/refseq/

 genbank: ftp://ftp.ncbi.nlm.nih.gov/genomes/genbank/

and creates a directory 'set_CDSs' to store
the CDSs of interest as fasta files for future processing.
In case the corresponding fasta file already exists within the
'set_CDSs' folder and is accessible within the workspace,
no download process will be performed.
}
\examples{
\dontrun{
getBioSet("refseq", organisms = c("Arabidopsis thaliana",
                                  "Arabidopsis lyrata",
                                  "Capsella rubella"),
                                  set_type = "cds")
}
}
\seealso{
Other getBioSet: 
\code{\link{getBioSet}()},
\code{\link{getCDSSet}()},
\code{\link{getGFFSet}()},
\code{\link{getGenomeSet}()},
\code{\link{getProteomeSet}()},
\code{\link{getRNASet}()}

Other collection: 
\code{\link{getCollection}()}
}
\author{
Hajk-Georg Drost
}
\concept{collection}
\concept{getBioSet}
