% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_genome.R
\name{summary_genome}
\alias{summary_genome}
\title{Retrieve summary statistics for a genome assembly file}
\usage{
summary_genome(file, organism)
}
\arguments{
\item{file}{file path to a genome assembly file in \code{fasta} format.}

\item{organism}{character string specifying the organism at hand.}
}
\description{
A summary statistics of specific genome features is generated.
These statistics are useful to assess the genome quality of retrieved genome assemblies
when performing comparative genomics tasks. This way, users can assess whether or not
patterns found based on genome comparisons aren't just a technical artifact of
differences in genome assembly quality.
}
\details{
The summary statistics include: 
\itemize{
\item \code{genome_size_mbp}: Genome size in mega base pairs
\item \code{n50_mbp}: The N50 contig size of the genome assembly in mega base pairs
\item \code{n_seqs}: The number of chromosomes/scaffolds/contigs of the genome assembly file
\item \code{n_nnn}: The absolute number of NNNs (over all chromosomes or scaffolds or contigs) in the genome assembly file
\item \code{rel_nnn}: The percentage (relative frequency) of NNNs (over all chromosomes or scaffolds or contigs) compared to the total number of 
nucleotides in the genome assembly file
\item \code{genome_entropy}: The \code{Shannon Entropy} of the genome assembly file (median entropy over all individual chromosome entropies)
\item \code{n_gc}: The total number of GCs 
(over all chromosomes or scaffolds or contigs) in the genome assembly file
\item \code{rel_gc}: The (relative frequency) of GCs 
(over all chromosomes or scaffolds or contigs) compared to the total number of 
nucleotides in the genome assembly file
}
}
\examples{
\dontrun{
# retrieve genome from NCBI RefSeq
Sc <- biomartr::getGenome(db = "refseq", organism = "Saccharomyces cerevisiae")
# compute genome assembly summary statistics
Sc_genome_summary <- summary_genome(file = Sc, organism = "Saccharomyces cerevisiae")
# look at results
Sc_genome_summary
}
}
\seealso{
\code{\link{summary_cds}}, \code{\link{getCollection}}, \code{\link{getGenome}}, \code{\link{read_genome}}
}
\author{
Hajk-Georg Drost
}
