% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getGFF.R
\name{getGFF}
\alias{getGFF}
\title{Genome Annotation Retrieval}
\usage{
getGFF(db = "refseq", organism, path = file.path("_ncbi_downloads",
  "annotation"))
}
\arguments{
\item{db}{a character string specifying the database from which the genome shall be retrieved: \code{db = "refseq"}, \code{db = "genbank"}, or \code{db = "ensembl"}.}

\item{organism}{a character string specifying the scientific name of the organism of interest, e.g. \code{organism = "Homo sapiens"}.}

\item{path}{a character string specifying the location (a folder) in which the corresponding
annotation file shall be stored. Default is \code{path = file.path("_ncbi_downloads","genomes")}.}
}
\value{
File path to downloaded annotation file.
}
\description{
Main retrieval function for GFF files of an organism of interest.
By specifying the scientific name of an organism of interest the corresponding gff file storing the annotation  for the organism of interest
can be downloaded and stored locally. GFF files can be retrieved from several databases.
}
\details{
Internally this function loads the the overview.txt file from NCBI:

 refseq: ftp://ftp.ncbi.nlm.nih.gov/genomes/refseq/

 genbank: ftp://ftp.ncbi.nlm.nih.gov/genomes/genbank/
 
and creates a directory '_ncbi_downloads/annotation' to store
the genome of interest as fasta file for future processing.
In case the corresponding fasta file already exists within the
'_ncbi_downloads/annotation' folder and is accessible within the workspace,
no download process will be performed.
}
\examples{
\dontrun{

# download the annotation of Arabidopsis thaliana from refseq
# and store the corresponding genome file in '_ncbi_downloads/annotation'
getGFF( db       = "refseq", 
               organism = "Arabidopsis thaliana", 
               path = file.path("_ncbi_downloads","annotation"))


# download the genome of Arabidopsis thaliana from genbank
# and store the corresponding genome file in '_ncbi_downloads/annotation'
getGFF( db       = "genbank", 
               organism = "Arabidopsis thaliana", 
               path = file.path("_ncbi_downloads","annotation"))

}

}
\seealso{
\code{\link{getProteome}}, \code{\link{getCDS}}, \code{\link{getGenome}}, \code{\link{meta.retrieval}}
}
\author{
Hajk-Georg Drost
}
