## ---- echo = FALSE, message = FALSE-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
options(width = 750)
knitr::opts_chunk$set(
  comment = "#>",
  error = FALSE,
  tidy = FALSE)

## ----eval=FALSE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # install the biomaRt package
#  source("http://bioconductor.org/biocLite.R")
#  biocLite("biomaRt")
#  
#  # load biomaRt
#  library(biomaRt)
#  
#  # look at top 10 databases
#  head(listMarts(), 10)

## ----eval=FALSE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  tail(listDatasets(useMart("plants_mart_26")), 10)

## ----eval=FALSE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  head(listAttributes(useDataset(dataset = "athaliana_eg_gene", mart = useMart("plants_mart_26"))), 10)

## ----eval=FALSE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  head(listFilters(useDataset(dataset = "athaliana_eg_gene", mart = useMart("plants_mart_26"))), 10)

## ----eval=FALSE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # 1) select a mart and data set
#  mart <- useDataset("athaliana_eg_gene", mart = useMart("plants_mart_26"))
#  
#  # 2) run a biomart query using the getBM() function
#  # and specify the attributes and filter arguments
#  geneSet <- c("AT1G06090", "AT1G06100", "AT1G06110", "AT1G06120", "AT1G06130", "AT1G06200")
#  
#  resultTable <- getBM(attributes = c("start_position","end_position","description"),
#                       filters = "tair_locus", values = geneSet, mart = mart)
#  
#  resultTable

## ----eval=FALSE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # load the biomartr package
#  library(biomartr)
#  
#  # list all available databases (top 10)
#  head(getMarts(), 10)

## ----eval=FALSE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  head(getDatasets(mart = "plants_mart_26") , 5)

## ----eval=FALSE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  tail(getDatasets(mart = "plants_mart_26") , 3)

## ----eval=FALSE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # list all available attributes for dataset: athaliana_eg_gene
#  head( getAttributes(mart = "plants_mart_26", dataset = "athaliana_eg_gene"), 10 )

## ----eval=FALSE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # list all available filters for dataset: athaliana_eg_gene
#  head( getFilters(mart = "plants_mart_26", dataset = "athaliana_eg_gene"), 10 )

## ----eval=FALSE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # retrieving all available datasets and biomart connections for
#  # a specific query organism (scientific name)
#  organismBM(organism = "Arabidopsis thaliana")

## ----eval=FALSE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # retrieving all available datasets and biomart connections for "Homo sapiens"
#  organismBM(organism = "Homo sapiens")

## ----eval=FALSE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # return available attributes for "Arabidopsis thaliana"
#  head(organismAttributes("Arabidopsis thaliana"), 20)

## ----eval=FALSE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # search for attribute topic "id"
#  head(organismAttributes("Arabidopsis thaliana", topic = "id"), 20)

## ----eval=FALSE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # search for attribute topic "homolog"
#  head(organismAttributes("Arabidopsis thaliana", topic = "homolog"), 20)

## ----eval=FALSE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # search for attribute topic "dn"
#  organismAttributes("Arabidopsis thaliana", topic = "dn")

## ----eval=FALSE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # search for attribute topic "ds"
#  organismAttributes("Arabidopsis thaliana", topic = "ds")

## ----eval=FALSE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # return available filters for "Arabidopsis thaliana"
#  head(organismFilters("Arabidopsis thaliana"), 20)

## ----eval=FALSE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # search for filter topic "id"
#  head(organismFilters("Arabidopsis thaliana", topic = "id"), 20)

## ----eval=FALSE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  organismAttributes("Arabidopsis thaliana", topic = "id")

## ----eval=FALSE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # retrieve the proteome of Arabidopsis thaliana from refseq
#  getProteome( db       = "refseq",
#               kingdom  = "plant",
#               organism = "Arabidopsis thaliana",
#               path     = file.path("_ncbi_downloads","proteomes") )
#  
#  
#  file_path <- file.path("_ncbi_downloads","proteomes","Arabidopsis_thaliana_protein.faa.gz")
#  
#  Ath_proteome <- read_proteome(file_path, format = "fasta")
#  
#  # remove splice variants from id
#  gene_set <- unlist(sapply(strsplit(Ath_proteome[1:5 , geneids], ".",fixed = TRUE),function(x) x[1]))
#  
#  result_BM <- biomart( genes      = gene_set,
#                        mart       = "plants_mart_26",
#                        dataset    = "athaliana_eg_gene",
#                        attributes = c("tair_locus","ensembl_peptide_id",
#                                       "external_transcript_id","interpro_id",
#                                       "nasc_gene_id"),
#                        filters    = "refseq_peptide")
#  
#  result_BM
#  

## ----eval=FALSE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # search for GO terms of 6 Arabidopsis thaliana genes in tair locus id notation
#  GO_tbl <- getGO(organism = "Arabidopsis thaliana",
#                  genes    = c("AT1G06100", "AT1G06110", "AT1G06120", "AT1G06130", "AT1G06200"),
#                  filters  = "tair_locus",
#                  database = "BioMart")
#  
#  # look at the GO information
#  GO_tbl[ , c("tair_locus","go_accession","go_name_1006")]

