% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/getAttributes.R
\name{getAttributes}
\alias{getAttributes}
\title{Retrieve All Available Attributes for a Specific Dataset}
\usage{
getAttributes(mart, dataset)
}
\arguments{
\item{mart}{a character string specifying the database (mart) for which datasets shall be listed.}

\item{dataset}{a character string specifying the dataset for which attributes shall be listed.}
}
\description{
This funcion queries the BioMart Interface and returns a table
storing all available attributes for a specific dataset.
}
\examples{
\dontrun{

# search for available datasets
head(getMarts(), 10)

# choose database (mart): "plants_mart_25"
# and get a table of all available datasets from this BioMart database
head(getDatasets(mart = "plants_mart_25"), 10)

# choose dataset: "athaliana_eg_gene"
head(getAttributes(mart = "plants_mart_25", dataset = "athaliana_eg_gene") , 5)

}
}
\author{
Hajk-Georg Drost
}
\seealso{
\code{\link{getMarts}}, \code{\link{getDatasets}},\code{\link{getFilters}}, \code{\link{organismBM}}, \code{\link{organismFilters}}, \code{\link{organismAttributes}}
}

