% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/sequence_io.R
\name{read_proteome}
\alias{read_proteome}
\title{Read the proteome of a given Organism}
\usage{
read_proteome(file, format, ...)
}
\arguments{
\item{file}{a character string specifying the path to the file storing the proteome.}

\item{format}{a character string specifying the file format used to store the proteome, e.g. "fasta", "gbk".}

\item{...}{additional arguments that are used by the seqinr::read.fasta() function.}
}
\value{
A data.table storing the gene id in the first column and the corresponding
sequence as string in the second column.
}
\description{
This function reads an organism specific proteome stored in a defined file format.
}
\details{
The \code{read.proteome} function takes a string specifying the path to the proteome file
of interest as first argument.

It is possible to read in different proteome file standards such as \emph{fasta} or \emph{genebank}.

Proteomes stored in fasta files can be downloaded from http://www.ebi.ac.uk/reference_proteomes.
}
\examples{
\dontrun{
# reading a proteome stored in a fasta file
Ath.proteome <- read.proteome(system.file('seqs/ortho_thal_aa.fasta', package = 'orthologr'),
                               format = "fasta")
}
}
\author{
Hajk-Georg Drost
}

