% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_MCMC_growth.R
\name{predict_MCMC_growth}
\alias{predict_MCMC_growth}
\title{Stochastic growth of MCMC fit}
\usage{
predict_MCMC_growth(
  MCMCfit,
  times,
  env_conditions,
  niter,
  newpars = NULL,
  formula = . ~ time
)
}
\arguments{
\item{MCMCfit}{An instance of \code{FitDynamicGrowthMCMC} or
\code{FitMultipleGrowthMCMC}.}

\item{times}{Numeric vector of storage times for the predictions.}

\item{env_conditions}{Tibble with the (dynamic) environmental conditions
during the experiment. It must have one column named 'time' with the
storage time and as many columns as required with the environmental conditions.}

\item{niter}{Number of iterations.}

\item{newpars}{A named list defining new values for the some model parameters.
The name must be the identifier of a model already included in the model.
These parameters do not include variation, so defining a new value for a fitted
parameters "fixes" it. \code{NULL} by default (no new parameters).}

\item{formula}{A formula stating the column named defining the elapsed time in
\code{env_conditions}. By default, . ~ time.}
}
\value{
An instance of \code{\link[=MCMCgrowth]{MCMCgrowth()}}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#superseded}{\figure{lifecycle-superseded.svg}{options: alt='[Superseded]'}}}{\strong{[Superseded]}}

The function \code{\link[=predict_MCMC_growth]{predict_MCMC_growth()}} has been superseded by \code{\link[=predictMCMC]{predictMCMC()}}
S3 methods of the relevant classes.

Nonetheless, it can still make a prediction of microbial growth including
parameter uncertainty based on a growth model
fitted using \code{\link[=fit_MCMC_growth]{fit_MCMC_growth()}} or \code{\link[=fit_multiple_growth_MCMC]{fit_multiple_growth_MCMC()}}.
This function predicts growth curves for \code{niter} samples (with replacement)
of the samples of the MCMC algorithm. Then, credible intervals are calculated based on the
quantiles of the model predictions at each time point.
}
\examples{
\donttest{
## We need a FitDynamicGrowthMCMC object

data("example_dynamic_growth")
data("example_env_conditions")

sec_model_names <- c(temperature = "CPM", aw= "CPM")

known_pars <- list(Nmax = 1e4,  # Primary model
    N0 = 1e0, Q0 = 1e-3,  # Initial values of the primary model
    mu_opt = 4, # mu_opt of the gamma model
    temperature_n = 1,  # Secondary model for temperature
    aw_xmax = 1, aw_xmin = .9, aw_n = 1  # Secondary model for water activity
    )

my_start <- list(temperature_xmin = 25, temperature_xopt = 35,
    temperature_xmax = 40,
    aw_xopt = .95)

set.seed(12124) # Setting seed for repeatability

my_MCMC_fit <- fit_MCMC_growth(example_dynamic_growth, example_env_conditions,
    my_start, known_pars, sec_model_names, niter = 3000)

## Define the conditions for the simulation

my_times <- seq(0, 15, length = 50)
niter <- 2000

newpars <- list(N0 = 1e-1,  # A parameter that was fixed
                temperature_xmax = 120  # A parameter that was fitted
                )


## Make the simulations

my_MCMC_prediction <- predict_MCMC_growth(my_MCMC_fit,
    my_times,
    example_env_conditions, # It could be different from the one used for fitting
    niter,
    newpars)
    
## We can plot the prediction interval

plot(my_MCMC_prediction)

## We can also get the quantiles at each time point

print(my_MCMC_prediction$quantiles)
}

}
