% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FitIsoGrowth_class.R
\name{FitIsoGrowth}
\alias{FitIsoGrowth}
\alias{plot.FitIsoGrowth}
\alias{summary.FitIsoGrowth}
\alias{residuals.FitIsoGrowth}
\alias{coef.FitIsoGrowth}
\alias{vcov.FitIsoGrowth}
\alias{deviance.FitIsoGrowth}
\alias{fitted.FitIsoGrowth}
\alias{predict.FitIsoGrowth}
\title{FitIsoGrowth class}
\usage{
\method{plot}{FitIsoGrowth}(
  x,
  y = NULL,
  ...,
  line_col = "black",
  line_size = 1,
  line_type = 1,
  point_col = "black",
  point_size = 3,
  point_shape = 16
)

\method{summary}{FitIsoGrowth}(object, ...)

\method{residuals}{FitIsoGrowth}(object, ...)

\method{coef}{FitIsoGrowth}(object, ...)

\method{vcov}{FitIsoGrowth}(object, ...)

\method{deviance}{FitIsoGrowth}(object, ...)

\method{fitted}{FitIsoGrowth}(object, ...)

\method{predict}{FitIsoGrowth}(object, times = NULL, ...)
}
\arguments{
\item{x}{The object of class \code{FitIsoGrowth} to plot.}

\item{y}{ignored}

\item{...}{ignored}

\item{line_col}{Aesthetic parameter to change the colour of the line geom in the plot, see: \code{\link{geom_line}}}

\item{line_size}{Aesthetic parameter to change the thickness of the line geom in the plot, see: \code{\link{geom_line}}}

\item{line_type}{Aesthetic parameter to change the type of the line geom in the plot, takes numbers (1-6) or strings ("solid") see: \code{\link{geom_line}}}

\item{point_col}{Aesthetic parameter to change the colour of the point geom, see: \code{\link{geom_point}}}

\item{point_size}{Aesthetic parameter to change the size of the point geom, see: \code{\link{geom_point}}}

\item{point_shape}{Aesthetic parameter to change the shape of the point geom, see: \code{\link{geom_point}}}

\item{object}{an instance of FitIsoGrowth}

\item{times}{numeric vector describing the time points for the prediction.
If \code{NULL} (default), uses the same points as those used for fitting.}
}
\description{
The \code{FitIsoGrowth} class contains a growth model fitted to data under
static conditions. Its constructor is \code{\link{fit_isothermal_growth}}.

It is a subclass of list with the items:
     \itemize{
         \item data: data used for model fitting
         \item model: name of the primary inactivation model
         \item starting_point: initial value of the model parameters
         \item known: fixed model parameters
         \item fit: object returned by \code{\link{modFit}}
         \item best_prediction: model prediction for the model fitted.
         }
}
\section{Functions}{
\itemize{
\item \code{plot.FitIsoGrowth}: compares the fitted model against the data.

\item \code{summary.FitIsoGrowth}: statistical summary of the fit.

\item \code{residuals.FitIsoGrowth}: vector of model residuals.

\item \code{coef.FitIsoGrowth}: vector of fitted model parameters.

\item \code{vcov.FitIsoGrowth}: variance-covariance matrix of the model, estimated
as 1/(0.5*Hessian)

\item \code{deviance.FitIsoGrowth}: deviance of the model.

\item \code{fitted.FitIsoGrowth}: vector of fitted values.

\item \code{predict.FitIsoGrowth}: vector of model predictions.
}}

