% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/criterions.R
\name{calc_criterion}
\alias{calc_criterion}
\title{Calculate criterion}
\usage{
calc_criterion(target, features, criterion_function)
}
\arguments{
\item{target}{\code{integer} vector with target information (e.g. class labels).}

\item{features}{\code{integer} matrix of features with number of rows equal
to the length of the target vector.}

\item{criterion_function}{a function calculating criterion. For a full list, see See also.}
}
\value{
a \code{integer} vector of length equal to the number of features
containing computed information gain values.
}
\description{
Calculates independently chosen statistical criterion for each feature versus target vector.
}
\details{
Permutation test implemented in \code{biogram} uses several criterions to filter
important features. Each can be used by \code{\link{test_features}} by specifying
\code{criterion} parameter.

Possible criterions are:
\describe{
  \item{ig}{Information Gain. Calculated using \code{\link{calc_ig}}.}
  \item{kl}{Kullback-Leibler divergence. Calculated using \code{\link{calc_kl}}.}
}
}
\note{
Both \code{target} and \code{features} must be binary, i.e. contain only 0
and 1 values.
}
\examples{
calc_criterion(sample(0L:1, 100, replace = TRUE),
               matrix(sample(0L:1, 400, replace = TRUE), ncol = 4),
               calc_ig)
}
\seealso{
\code{\link{test_features}}.
}

