\name{areaGE}
\encoding{UTF-8}
\alias{areaGE}
\title{
Area Calculation for the Gielis Curve Within \eqn{[0, 2\pi)}
}
\description{
\code{areaGE} is used to calculate the area of the polygon 
generated by the Gielis curve within \eqn{[0, 2\pi)}.
}
\usage{
areaGE(expr, P, m = 1, simpver = NULL,  
       nval = 1, subdivisions = 100L,
       rel.tol = .Machine$double.eps^0.25, 
       abs.tol = rel.tol, stop.on.error = TRUE, 
       keep.xy = FALSE, aux = NULL)
}
\arguments{
  \item{expr}{the original (or twin) Gielis equation or one of its simplified versions.}
  \item{P}{the parameters of the original (or twin) Gielis equation or one of its simplified versions.}
  \item{m}{the given \eqn{m} value that determines the number of angles of the Gielis curve within \eqn{[0, 2\pi)}.}
  \item{simpver}{an optional argument to use the simplified version of the original (or twin) Gielis equation.}
  \item{nval}{the specified value for \eqn{n_{1}} or \eqn{n_{2}} or \eqn{n_{3}} in the simplified versions.}
  \item{subdivisions}{please see the arguments for the \code{\link{integrate}} function in package \pkg{stats}.}
  \item{rel.tol}{please see the arguments for the \code{\link{integrate}} function in package \pkg{stats}.}
  \item{abs.tol}{please see the arguments for the \code{\link{integrate}} function in package \pkg{stats}.}
  \item{stop.on.error}{please see the arguments for the \code{\link{integrate}} function in package \pkg{stats}.}
  \item{keep.xy}{please see the arguments for the \code{\link{integrate}} function in package \pkg{stats}.}
  \item{aux}{please see the arguments for the \code{\link{integrate}} function in package \pkg{stats}.}
}
\details{
The arguments of \code{P}, \code{m}, \code{simpver}, and \code{nval} should correspond 
to \code{expr} (i.e., \code{GE} or \code{TGE}). Please note the differences in the simplified 
version number and the number of parameters between \code{GE} and \code{TGE}.
}
\value{
The area of the polygon within \eqn{[0, 2\pi)} generated by the original (or twin) Gielis equation 
or one of its simplified versions.
}
\note{
\code{simpver} in \code{GE} is different from that in \code{TGE}.
}
\author{
Peijian Shi \email{pjshi@njfu.edu.cn}, Johan Gielis \email{johan.gielis@uantwerpen.be}, 
Brady K. Quinn \email{Brady.Quinn@dfo-mpo.gc.ca}.
}
\references{
Gielis, J. (2003) A generic geometric transformation that unifies a wide range of natural 
and abstract shapes. \emph{American Journal of Botany} 90, 333\eqn{-}338. \doi{10.3732/ajb.90.3.333}

Li, Y., Quinn, B.K., Gielis, J., Li, Y., Shi, P. (2022) Evidence that supertriangles exist 
in nature from the vertical projections of \emph{Koelreuteria paniculata} fruit. \emph{Symmetry} 
14, 23. \doi{10.3390/sym14010023}

Shi, P., Gielis, J., Quinn, B.K., Niklas, K.J., Ratkowsky, D.A., Schrader, J., Ruan, H., 
Wang, L., Niinemets, Ü. (2022) 'biogeom': An R package for simulating and fitting natural 
shapes. \emph{Annals of the New York Academy of Sciences} 1516, 123\eqn{-}134. \doi{10.1111/nyas.14862}

Shi, P., Ratkowsky, D.A., Gielis, J. (2020) The generalized Gielis geometric 
equation and its application. \emph{Symmetry} 12, 645. \doi{10.3390/sym12040645}

Shi, P., Xu, Q., Sandhu, H.S., Gielis, J., Ding, Y., Li, H., Dong, X. (2015) Comparison
of dwarf bamboos (\emph{Indocalamus} sp.) leaf parameters to determine relationship
between spatial density of plants and total leaf area per plant. \emph{Ecology and Evolution} 5,
4578\eqn{-}4589. \doi{10.1002/ece3.1728}
}
\seealso{
\code{\link{curveGE}}, \code{\link{fitGE}}, \code{\link{GE}}, \code{\link{TGE}}
}
\examples{
Para1 <- c(1.7170, 5.2258, 7.9802)
areaGE(GE, P = Para1, m=5, simpver=1)

Para2 <- c(2.1066, 3.5449, 0.4619, 10.5697)
areaGE(TGE, P = Para2, m=5, simpver=1)
}