#' Compose BioCompute Object - Top Level Fields (v1.4.2)
#'
#' @param provenance Provenance domain
#' @param usability Usability domain
#' @param extension Extension domain
#' @param description Description domain
#' @param execution Execution domain
#' @param parametric Parametric domain
#' @param io I/O domain
#' @param error Error domain
#' @param object_id BioCompute Object identifier
#' (\href{https://github.com/biocompute-objects/BCO_Specification/blob/1.4.2/docs/top-level.md#202-biocompute-object-identifier-object_id}{definition}).
#' If \code{NULL}, will use a UUID generated by \code{\link{generate_id}}.
#'
#' @return A vector of top level fields
#'
#' @importFrom uuid UUIDgenerate
#'
#' @rdname compose_tlf
#' @export compose_tlf_v1.4.2
#'
#' @examples
#' compose_tlf(
#'   compose_provenance(), compose_usability(), compose_extension(),
#'   compose_description(), compose_execution(), compose_parametric(),
#'   compose_io(), compose_error()
#' ) %>% convert_json()
compose_tlf_v1.4.2 <-
  function(
           provenance, usability, extension, description,
           execution, parametric, io, error, object_id = NULL) {
    spec_version <- "https://w3id.org/biocompute/1.4.2/"
    if (is.null(object_id)) object_id <- generate_id("sevenbridges")

    lst <- list(
      "provenance_domain" = provenance,
      "usability_domain" = usability,
      "extension_domain" = extension,
      "description_domain" = description,
      "execution_domain" = execution,
      "parametric_domain" = parametric,
      "io_domain" = io,
      "error_domain" = error
    )

    json <- convert_json(lst)
    etag <- digest::digest(json, algo = "sha256")

    domain <- c(
      "spec_version" = spec_version,
      "object_id" = object_id,
      "etag" = etag
    )
    domain
  }

#' @rdname compose_tlf
#' @export compose_tlf
compose_tlf <- compose_tlf_v1.4.2
