% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beam.R
\name{beam_width}
\alias{beam_width}
\title{Calculate radar beam width}
\usage{
beam_width(range, beam_angle = 1)
}
\arguments{
\item{range}{Numeric. Range, i.e. distance from the radar antenna, in m.}

\item{beam_angle}{Numeric. Beam opening angle in degrees, typically the
angle between the half-power (-3 dB) points of the main lobe.}
}
\value{
numeric. Beam width in m, typically the full width at half maximum (FWHM).
}
\description{
Calculates the width of a radar beam as a function of range and beam angle.
}
\examples{
#' # Beam width in meters at 10 km range:
beam_width(10000)

# Define ranges from 0 to 1000000 m (100 km), in steps of 100 m:
range <- seq(0, 100000, 100)

# Plot the beam width as a function of range:
plot(range, beam_width(range), ylab = "beam width [m]", xlab = "range [m]")
}
\seealso{
Other beam_functions: 
\code{\link{beam_distance}()},
\code{\link{beam_height}()},
\code{\link{beam_profile_overlap}()},
\code{\link{beam_profile}()},
\code{\link{beam_range}()},
\code{\link{gaussian_beam_profile}()}
}
\concept{beam_functions}
