% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_basemap.R
\name{download_basemap}
\alias{download_basemap}
\title{Download a basemap for \code{map(ppi)}}
\usage{
download_basemap(
  x,
  verbose = TRUE,
  zoom,
  alpha = 1,
  source = "stamen",
  maptype = "terrain",
  ...
)
}
\arguments{
\item{x}{A \code{ppi} object.}

\item{verbose}{Logical. When \code{TRUE}, prints information to console.}

\item{zoom}{Integer. Optional zoom level from 3 (continent) to 21 (building),
see \code{\link[ggmap:get_map]{ggmap::get_map()}}. When undefined, the zoom level will be the one
matching the \code{ppi} extent.}

\item{alpha}{Numeric. Transparency of the basemap, value between 0 and 1.}

\item{source}{Character. Map service to be used: \code{stamen} or \code{google}.}

\item{maptype}{Character. Type of basemap to plot. For Stamen Maps:
\code{terrain}, \code{terrain-background}, \code{terrain-labels}, \code{terrain-lines},
\code{toner}, \code{toner-2010}, \code{toner-2011}, \code{toner-background}, \code{toner-hybrid},
\code{toner-labels}, \code{toner-lines}, \code{toner-lite} or \code{watercolor}. For Google
Maps: \code{terrain}, \code{satellite}, \code{roadmap} or \code{hybrid}.}

\item{...}{Arguments to pass to \code{\link[ggmap:get_map]{ggmap::get_map()}}.}
}
\value{
A ggmap object for \code{map(ppi)}
}
\description{
Downloads a basemap for \code{\link[=map.ppi]{map.ppi()}} from Stamen Maps or Google Maps using
\code{\link[ggmap:get_map]{ggmap::get_map()}}. To use Google Maps as \code{source}, you will have to register
with Google, enable billing and provide an API key to ggmap. See the \href{https://github.com/dkahle/ggmap#attention}{ggmap README} for details.
}
\examples{
# Project a scan as a ppi
ppi <- project_as_ppi(example_scan)
\donttest{
# Create a basemap that matches the extent of the ppi
basemap <- download_basemap(ppi)

# Map the radial velocity of the ppi onto the basemap
map(ppi, map = basemap, param = "VRADH")

# Increase the transparency of the basemap
basemap <- download_basemap(ppi, alpha = 0.3)
map(ppi, map = basemap, param = "VRADH")

# Download a different type of basemap, e.g. a gray-scale image.
# See get_map() in ggmap library for full documentation of the options.
basemap <- download_basemap(ppi, maptype = "toner-lite")
map(ppi, map = basemap, param = "VRADH")
}
}
\seealso{
\itemize{
\item \code{\link[=map.ppi]{map.ppi()}}
}
}
