% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_param.R
\name{get_param}
\alias{get_param}
\title{Get a parameter (\code{param}) from a scan (\code{scan})}
\usage{
get_param(x, param)
}
\arguments{
\item{x}{A \code{scan} object.}

\item{param}{Character. A scan parameter, such as \code{DBZH} or \code{VRADH}. See
\code{\link[=summary.param]{summary.param()}} for commonly available parameters.}
}
\value{
A \code{param} object.
}
\description{
Returns the selected parameter (\code{param}) from a scan (\code{scan}).
}
\examples{
# Load the example scan
scan <- example_scan

# Get summary info (including parameters)
scan

# Extact the VRADH scan parameter
param <- get_param(scan, "VRADH")

# Get summary info for this parameter
param
}
\seealso{
\code{\link[=summary.param]{summary.param()}}
}
