% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rcs.R
\name{rcs<-}
\alias{rcs<-}
\alias{rcs<-.vp}
\alias{rcs<-.list}
\alias{rcs<-.vpts}
\alias{rcs<-.vpi}
\title{Set radar cross section}
\usage{
rcs(x) <- value

\method{rcs}{vp}(x) <- value

\method{rcs}{list}(x) <- value

\method{rcs}{vpts}(x) <- value

\method{rcs}{vpi}(x) <- value
}
\arguments{
\item{x}{a \code{vp}, list of \code{vp} or \code{vpts} object}

\item{value}{the cross section value to assign}
}
\description{
Sets the assumed radar cross section in cm^2. This method also updates
the migration densities in \code{x$data$dens}
}
\details{
See also \link{rcs} for retrieving the radar cross section
of an object.
}
\examples{
# load example data
data(example_vp)
data(example_vpts)

# change or set RCS for a single vertical profile:
rcs(example_vp) <- 11

# change or set RCS for a vertical profile time series:
rcs(example_vpts) <- 11

# retrieve RCS for a single vertical profile:
rcs(example_vp)

# retrieve RCS for a vertical profile time series:
rcs(example_vpts)
}
