% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pvol.R
\name{summary.pvol}
\alias{summary.pvol}
\alias{is.pvol}
\title{Class \code{pvol}: a polar volume}
\usage{
\method{summary}{pvol}(object, ...)

is.pvol(x)
}
\arguments{
\item{object}{Object of class \code{pvol}.}

\item{...}{Additional arguments affecting the summary produced.}

\item{x}{Object of class \code{pvol}.}
}
\value{
for \code{is.pvol}: \code{TRUE} if its argument is of
class \code{pvol}
}
\description{
Class \code{pvol} for a polar volume, and its associated R base functions.
}
\details{
An object of class \code{pvol} is a list containing:
\describe{
 \item{\code{radar}}{character string with the radar identifier}
 \item{\code{datetime}}{nominal time of the volume [UTC]}
 \item{\code{scans}}{a list with scan objects of class 'scan'}
 \item{\code{attributes}}{list with the volume's \code{\\what},
   \code{\\where} and \code{\\how} attributes}
 \item{\code{geo}}{geographic data, a list with:
  \describe{
     \item{\code{lat}}{latitude of the radar [decimal degrees]}
     \item{\code{lon}}{longitude of the radar [decimal degrees]}
     \item{\code{height}}{height of the radar
       antenna [meters above sea level]}
  }
 }
}
}
\examples{
# locate example volume file:
pvolfile <- system.file("extdata", "volume.h5", package = "bioRad")

# print the local path of the volume file:
pvolfile

# load the file:
example_pvol <- read_pvolfile(pvolfile)

# print summary info for the loaded polar volume:
example_pvol

# verify that this is a pvol object:
is.pvol(example_pvol)

# print summary info for the scans in the polar volume:
example_pvol$scans

# copy the first scan to a new object 'scan':
scan <- example_pvol$scans[[1]]

# print summary info for the scan:
scan
is.pvol("this is not a polar volume but a string") # > FALSE
}
