% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_scan.R
\name{get_scan}
\alias{get_scan}
\title{Get a scan (\code{scan}) from a polar volume (\code{pvol})}
\usage{
get_scan(x, elev)
}
\arguments{
\item{x}{An object of class \code{pvol}.}

\item{elev}{Elevation angle.}
}
\value{
An object of class '\link[=summary.scan]{scan}'.
}
\description{
Get a scan (\code{scan}) from a polar volume (\code{pvol})
}
\details{
The function returns the scan with elevation angle closest
to \code{elev}.
}
\examples{
# locate example volume file:
pvolfile <- system.file("extdata", "volume.h5", package = "bioRad")

# load the file:
example_pvol <- read_pvolfile(pvolfile)

# extract the scan at 3 degree elevation:
scan <- get_scan(example_pvol, 3)

# print summary info for this scan:
scan
}
