% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trajPlot.R
\name{trajPlot}
\alias{trajPlot}
\title{Creates a map and pie chart of the trajectories of the category of interest.}
\usage{
trajPlot(
  input,
  pltunit = "m",
  dataEpsg = 32632,
  categoryName = "marsh's",
  scalePos = "bottomleft",
  narrowPos = "topright",
  narrowSize = 1,
  xAxis = "Longitude (m)",
  yAxis = "Latitude (m)",
  axisText = 1.2,
  axisLabel = 1.4,
  plotTitle = 1.5,
  legendTex = 0.9
)
}
\arguments{
\item{input}{is the results from running the "trajData" function.}

\item{pltunit}{is the unit in which the current map is plotted in, one of cm, m, km, in, ft, mi. or lat or lon.}

\item{dataEpsg}{is the projection of the current map. If extents are valid lat and lons,
the projection is assumed to be lat and lon (EPSG:4326), or Spherical Mercator otherwise.}

\item{categoryName}{is a character representing the name of the category of interest.Default is "marsh".}

\item{scalePos}{where to align the scale bar. One of "bottomleft", "bottomright", "topleft", or "topright".}

\item{narrowPos}{is a numeric value indicating the size of the north arrow.}

\item{narrowSize}{is a numeric value indicating the size of the north arrow.}

\item{xAxis}{is a character indicating label for the horizontal axis. default is "Longitude (m)".}

\item{yAxis}{is a character indicating label for the vertical axis. default is "Latitude (m)".}

\item{axisText}{is a numeric value controlling the size of the text on the horizontal and vertical ticks.}

\item{axisLabel}{is a numeric value controlling the size of the  horizontal and vertical labels}

\item{plotTitle}{is a numeric value controlling the size of the plot title.}

\item{legendTex}{is a numerical value controlling the size of the legend text.}
}
\value{
The output from \code{\link{trajPlot}}
}
\description{
Creates a map and pie chart of the trajectories of the category of interest.
}
\examples{
example_data <- terra::rast(system.file("external/Example_raster_Y.tif",package="binaryTimeSeries"))
no_data <- 2
cat_interest <- 1
data_res <- c(1000,1000)
data_prj <- "+proj=utm +zone=32 +datum=WGS84 +ellps=GRS80  +units=m +no_defs"
unified_resp <- "yes"
trajdt_output <- trajData(x = example_data,nodata = no_data,
category = cat_interest,spres = data_res,datacrs = data_prj,unified = unified_resp)
trjplt_output <- trajPlot(input = trajdt_output)

}
