% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bb_utils.R
\name{bb_zoom}
\alias{bb_zoom}
\title{Zoom property for a Billboard.js chart}
\usage{
bb_zoom(bb, ...)
}
\arguments{
\item{bb}{A \code{billboard} \code{htmlwidget} object.}

\item{...}{See \url{https://naver.github.io/billboard.js/release/latest/doc/Options.html#.zoom}}
}
\value{
A \code{billboard} \code{htmlwidget} object.
}
\description{
Zoom property for a Billboard.js chart
}
\examples{
# data
data("equilibre_mensuel")

# line chart
billboarder() \%>\% 
  bb_linechart(
    data = equilibre_mensuel[, c("date", "consommation", "production")], 
    type = "spline"
  ) \%>\% 
  bb_x_axis(tick = list(format = "\%Y-\%m", fit = FALSE)) \%>\% 
  bb_zoom(enabled = TRUE)

}
