% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bikm1_LBM_Poisson_functions.R
\name{ARI}
\alias{ARI}
\title{ARI function for agreement between two partitions}
\usage{
ARI(v,vprime)
}
\arguments{
\item{v}{numeric vector  specifying the class of observations.}

\item{vprime}{numeric vector specifying another partitions of observations.}
}
\value{
a list including the arguments:

  \code{ari}: value of the index.

  \code{nv}: contingency table which the index is based on.
}
\description{
Produce a measure of agreement between two partitions.
}
\examples{
\donttest{require(bikm1)
J=200
K=120
h=3
l=2
theta=list()
theta$rho_h=1/h *matrix(1,h,1)
theta$tau_l=1/l *matrix(1,l,1)
theta$gamma_hl=matrix(c(1, 6,4, 1, 7, 1),ncol=2)
data=PoissonBlocRnd(J,K,theta)
res=BIKM1_LBM_Poisson(data$x,4,4,4,init_choice='random')
mv=ARI(res@model_max$v, data$xrow)
mv$ari
mv$nv
mw=ARI(res@model_max$w, data$xcol)}

}
\references{
Hubert and Arabie. Comparing partitions. Journal of
  classification (1985).
}
