% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BIKM1_LBM_Poisson-class.R
\name{plot,BIKM1_LBM_Poisson-method}
\alias{plot,BIKM1_LBM_Poisson-method}
\title{Plot method for a \code{\linkS4class{BIKM1_LBM_Poisson}} object}
\usage{
\S4method{plot}{BIKM1_LBM_Poisson}(x, y, ...)
}
\arguments{
\item{x}{an object of class \code{BIKM1_LBM_Poisson}.}

\item{y}{a list specifying

\code{x} : contingency matrix of observations.}

\item{...}{in the plot method, additional parameters (ignored)}
}
\value{
Two \pkg{plot} and two \pkg{ggplot2} object.
}
\description{
Produce respectively one plot of two-dimensional segmentation of a \code{BIKM1_LBM_Poisson} fit, an evolution of the criterion as a function of the numbers of rows and columns, and a boxplot of conditional posteriors for each row and column cluster.
}
\examples{
\donttest{require(bikm1)
J=200
K=120
h=3
l=2
theta=list()
theta$rho_h=1/h *matrix(1,h,1)
theta$tau_l=1/l *matrix(1,l,1)
theta$gamma_hl=matrix(c(1, 6,4, 1, 7, 1),ncol=2)
data=PoissonBlocRnd(J,K,theta)
res=BIKM1_LBM_Poisson(data$x,3,3,4,init_choice='random')
plot(res,data)}
}
