% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bikm1_MLBM_Binary_functions.R
\name{BinBlocVisu_MLBM}
\alias{BinBlocVisu_MLBM}
\title{BinBlocVisu_MLBM function for visualization of double matrix datasets}
\usage{
BinBlocVisu_MLBM(x,y,z,v,w)
}
\arguments{
\item{x}{first data matrix of observations.}

\item{y}{second data matrix of observations.}

\item{z}{a numeric vector specifying the class of rows.}

\item{v}{a numeric vector specifying the class of columns (1rst matrix).}

\item{w}{a numeric vector specifying the class of columns (2nd matrix).}
}
\value{
a \pkg{plot} object
}
\description{
Produce a plot object representing the coclustered data-sets.
}
\examples{

require(bikm1)
set.seed(42)
n=200
J=120
K=120
g=3
h=2
l=2
theta=list()
theta$pi_g=1/g *matrix(1,g,1)
theta$rho_h=1/h *matrix(1,h,1)
theta$tau_l=1/l *matrix(1,l,1)
theta$alpha_gh=matrix(runif(6),ncol=h)
theta$beta_gl=matrix(runif(6),ncol=l)
data=BinBlocRnd_MLBM(n,J,K,theta)
BinBlocVisu_MLBM(data$x,data$y, data$xrow,data$xcolx,data$xcoly)
}
