% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bikm1_LBM_Poisson_functions.R
\name{BIKM1_LBM_Poisson}
\alias{BIKM1_LBM_Poisson}
\title{BIKM1_LBM_Poisson fitting procedure}
\usage{
BIKM1_LBM_Poisson(x,Hmax,Lmax,a=4,alpha=1,beta=0.01,
Hstart=2,Lstart=2,normalization=FALSE,init_choice='smallVBayes',
userparam=NULL,ntry=50,criterion_choice='ICL', mc.cores=1,verbose=TRUE)
}
\arguments{
\item{x}{contingency matrix of observations.}

\item{Hmax}{a positive integer less than number of rows.}

\item{Lmax}{a positive integer less than number of columns.The bikm1 procedure stops while the numbers of rows is higher than Hmax or the number of columns is higher than Lmax.}

\item{a}{hyperparameter used in the VBayes algorithm for priors on the mixing proportions.
By default, a=4.}

\item{alpha}{hyperparameter used in the VBayes algorithm for prior on the Poisson parameter.
By default, alpha=1.}

\item{beta}{hyperparameter used in the VBayes algorithm for prior on the Poisson parameter.
By default, beta=0.01.}

\item{Hstart}{a positive integer to initialize the procedure with number of row clusters.
By default, Hstart=2.}

\item{Lstart}{a positive integer to initialize the procedure with number of column clusters.
By default, Lstart=2.}

\item{normalization}{logical. To use the normalized Poisson modelling in the Latent Block Model. By default normalization=FALSE.}

\item{init_choice}{character string corresponding to the chosen initialization strategy used for the procedure, which can be "random" or "Gibbs" (higher time computation) or "smallVBayes" or "user".
By default, init_choice="smallVBayes"}

\item{userparam}{In the case where init_choice is "user", a list containing partitions v and w.}

\item{ntry}{a positive integer corresponding to the number of times which is launched the small VBayes or random initialization strategy. By default ntry=50.}

\item{criterion_choice}{Character string corresponding to the chosen criterion used for model selection, which can be "ICL" or "BIC".
By default, criterion_choice="ICL".}

\item{mc.cores}{a positive integer corresponding to the available number of cores for parallel computing.
By default, mc.cores=1.}

\item{verbose}{logical. To display each step and the result. By default verbose=TRUE.}
}
\value{
a BIKM1_LBM_Poisson object including

\code{model_max}: the selected model by the procedure with free energy W, theta, conditional probabilities (r_jh, t_kl), iter, empty_cluster, and the selected partitions v and w.

\code{criterion_choice}: the chosen criterion

\code{init_choice}: the chosen init choice

\code{criterion tab}: matrix containing the criterion values for each selected number of row and column

\code{W_tab}: matrix containing the free energy values for each selected number of row and column

\code{criterion_max}: maximum of the criterion values

\code{hopt}: the selected number of rows

\code{lopt}: the selected number of columns
}
\description{
Produce a blockwise estimation of a contingency matrix of observations.
}
\examples{
require(bikm1)
J=200
K=120
h=3
l=2
theta=list()
theta$rho_h=1/h *matrix(1,h,1)
theta$tau_l=1/l *matrix(1,l,1)
theta$gamma_hl=matrix(c(1, 6,4, 1, 7, 1),ncol=2)
data=PoissonBlocRnd(J,K,theta)
res=BIKM1_LBM_Poisson(data$x,3,2,Hstart=3,Lstart=2,
init_choice='user',userparam=list(v=data$xrow,w=data$xcol))

}
\references{
Keribin, Celeux and Robert, The Latent Block Model: a useful model for high dimensional data.
https://hal.inria.fr/hal-01658589/document

Govaert and Nadif. Coclustering, Wyley (2013).

Keribin, Brault and Celeux. Estimation and Selection for the Latent Block Model on Categorical Data, Statistics and Computing (2014).

Robert. Classification crois\'ee pour l'analyse de bases de donn\'ees de grandes dimensions de pharmacovigilance. Paris Saclay (2017).
}
