% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/varma.R
\name{sparseVARMA}
\alias{sparseVARMA}
\title{Sparse Estimation of the Vector AutoRegressive Moving Average (VARMA) Model}
\usage{
sparseVARMA(
  Y,
  U = NULL,
  VARp = NULL,
  VARpen = "HLag",
  VARlseq = NULL,
  VARgran = NULL,
  VARselection = c("cv", "bic", "aic", "hq"),
  VARMAp = NULL,
  VARMAq = NULL,
  VARMApen = "HLag",
  VARMAlPhiseq = NULL,
  VARMAPhigran = NULL,
  VARMAlThetaseq = NULL,
  VARMAThetagran = NULL,
  VARMAalpha = 0,
  VARMAselection = c("none", "cv", "bic", "aic", "hq"),
  h = 1,
  cvcut = 0.9,
  eps = 10^-3,
  check_std = TRUE
)
}
\arguments{
\item{Y}{A \eqn{T} by \eqn{k} matrix of time series. If k=1, a univariate autoregressive moving average model is estimated.}

\item{U}{A \eqn{T} by \eqn{k} matrix of (approximated) error terms. Typical usage is to have the program estimate a high-order VAR model (Phase I) to get approximated error terms U.}

\item{VARp}{User-specified maximum  autoregressive lag order of the PhaseI VAR. Typical usage is to have the program compute its own maximum lag order based on the time series length.}

\item{VARpen}{"HLag" (hierarchical sparse penalty) or "L1" (standard lasso penalty) penalization in PhaseI VAR.}

\item{VARlseq}{User-specified grid of values for regularization parameter in the PhaseI VAR. Typical usage is to have the program compute
its own grid. Supplying a grid of values overrides this. WARNING: use with care.}

\item{VARgran}{User-specified vector of granularity specifications for the penalty parameter grid of the PhaseI VAR:  First element specifies
how deep the grid should be constructed. Second element specifies how many values the grid should contain.}

\item{VARselection}{Selection procedure for the first stage. Default is time series Cross-Validation. Alternatives are BIC, AIC, HQ}

\item{VARMAp}{User-specified maximum autoregressive lag order of the VARMA. Typical usage is to have the program compute its own maximum lag order based on the time series length.}

\item{VARMAq}{User-specified maximum moving average lag order of the VARMA. Typical usage is to have the program compute its own maximum lag order based on the time series length.}

\item{VARMApen}{"HLag" (hierarchical sparse penalty) or "L1" (standard lasso penalty) penalization in the VARMA.}

\item{VARMAlPhiseq}{User-specified grid of values for regularization parameter corresponding to the autoregressive coefficients in the VARMA. Typical usage is to have the program compute
its own grid. Supplying a grid of values overrides this. WARNING: use with care.}

\item{VARMAPhigran}{User-specified vector of granularity specifications for the penalty parameter grid corresponding to the autoregressive coefficients in the VARMA:  First element specifies
how deep the grid should be constructed. Second element specifies how many values the grid should contain.}

\item{VARMAlThetaseq}{User-specified grid of values for regularization parameter corresponding to the moving average coefficients in the VARMA. Typical usage is to have the program compute
its own grid. Supplying a grid of values overrides this. WARNING: use with care.}

\item{VARMAThetagran}{User-specified vector of granularity specifications for the penalty parameter grid corresponding to the moving average coefficients in the VARMA:  First element specifies
how deep the grid should be constructed. Second element specifies how many values the grid should contain.}

\item{VARMAalpha}{a small positive regularization parameter value corresponding to squared Frobenius penalty in  VARMA. The default is zero.}

\item{VARMAselection}{selection procedure in the second stage. Default is "none"; Alternatives are cv, bic, aic, hq}

\item{h}{Desired forecast horizon in time-series cross-validation procedure.}

\item{cvcut}{Proportion of observations used for model estimation in the time series cross-validation procedure. The remainder is used for forecast evaluation.}

\item{eps}{a small positive numeric value giving the tolerance for convergence in the proximal gradient algorithms.}

\item{check_std}{Check whether data is standardised. Default is TRUE and is not recommended to be changed}
}
\value{
A list with the following components
\item{Y}{\eqn{T} by \eqn{k} matrix of time series.}
\item{U}{Matrix of (approximated) error terms.}
\item{k}{Number of time series.}
\item{VARp}{Maximum autoregressive lag order of the PhaseI VAR.}
\item{VARPhihat}{Matrix of estimated autoregressive coefficients of the Phase I VAR.}
\item{VARphi0hat}{Vector of Phase I VAR intercepts.}
\item{VARMAp}{Maximum autoregressive lag order of the VARMA.}
\item{VARMAq}{Maximum moving average lag order of the VARMA.}
\item{Phihat}{Matrix of estimated autoregressive coefficients of the VARMA.}
\item{Thetahat}{Matrix of estimated moving average coefficients of the VARMA.}
\item{phi0hat}{Vector of VARMA intercepts.}
\item{series_names}{names of time series}
\item{PhaseI_lambas}{Phase I sparsity parameter grid}
\item{PhaseI_MSFEcv}{MSFE cross-validation scores for each value of the sparsity parameter in the considered grid}
\item{PhaseI_lambda_opt}{Phase I Optimal value of the sparsity parameter as selected by the time-series cross-validation procedure}
\item{PhaseI_lambda_SEopt}{Phase I Optimal value of the sparsity parameter as selected by the time-series cross-validation procedure and after applying the one-standard-error rule}
\item{PhaseII_lambdaPhi}{Phase II sparsity parameter grid corresponding to Phi parameters}
\item{PhaseII_lambdaTheta}{Phase II sparsity parameter grid corresponding to Theta parameters}
\item{PhaseII_lambdaPhi_opt}{Phase II Optimal value of the sparsity parameter (corresponding to Phi parameters) as selected by the time-series cross-validation procedure}
\item{PhaseII_lambdaPhi_SEopt}{Phase II Optimal value of the sparsity parameter (corresponding to Theta parameters) as selected by the time-series cross-validation procedure and after applying the one-standard-error rule}
\item{PhaseII_lambdaTheta_opt}{Phase II Optimal value of the sparsity parameter (corresponding to Phi parameters) as selected by the time-series cross-validation procedure}
\item{PhaseII_lambdaTheta_SEopt}{Phase II Optimal value of the sparsity parameter (corresponding to Theta parameters) as selected by the time-series cross-validation procedure and after applying the one-standard-error rule}
\item{PhaseII_MSFEcv}{Phase II MSFE cross-validation scores for each value in the two-dimensional sparsity grid}
\item{h}{Forecast horizon h}
}
\description{
Sparse Estimation of the Vector AutoRegressive Moving Average (VARMA) Model
}
\examples{
data(varma.example)
VARMAfit <- sparseVARMA(Y = scale(Y.varma)) # sparse VARMA
y <- matrix(Y.varma[,1], ncol=1)
ARMAfit <- sparseVARMA(Y=scale(y)) # sparse ARMA
}
\references{
Wilms Ines, Sumanta Basu, Bien Jacob and Matteson David S. (2021), “Sparse Identification and
Estimation of Large-Scale Vector AutoRegressive Moving Averages”, Journal of the American Statistical Association, doi: 10.1080/01621459.2021.1942013.
}
\seealso{
\link{lagmatrix} and \link{directforecast}
}
