% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_model.R
\name{summary.big}
\alias{summary.big}
\title{Summarizing model fit}
\usage{
\method{summary}{big}(object, ...)
}
\arguments{
\item{object}{an object of class \code{big}.}

\item{...}{Further arguments to be passed to or from other methods. They are
ignored in this function.}
}
\value{
An object of class \code{summary.lm}.
}
\description{
\code{summary} method for class \code{big}.
}
\examples{
set.seed(1)
n <- 30
p <- 10
X <- matrix(rnorm(n * p), ncol = p)
y <- X[, 2] + 2*X[, 3] - X[, 6] + rnorm(n)
d <- prepare_data(y, X)
m <- stepwise(d)
summary(m)
}
