% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transposeBigMatrix.R
\name{transposeBigMatrix}
\alias{transposeBigMatrix}
\title{Transpose a big matrix}
\usage{
transposeBigMatrix(X, file.out = "Xtrans.txt", ord = NULL, sep = "\\t",
  type = "char", row.names = TRUE, maxp = 1e+07, verbose = TRUE, ...)
}
\arguments{
\item{X}{an object of class big.matrix. The rows of \code{X} contain the
observed variables, the columns of \code{X} contain samples.}

\item{file.out}{a character string. The name of the output file.}

\item{ord}{a numeric vector. The order in which new variables will be
written (the size of \cite{ord} can be smaller than \cite{X} if you do not
want to write some variables).}

\item{sep}{a character, the field delimiter.}

\item{type}{a character string. The type of data. Set \cite{NA} if you do
not know (but preferably specified).}

\item{row.names}{a logical. If \cite{TRUE}, the first column contains the
row names.}

\item{maxp}{a numeric. If \code{X} is big, it will be splitted into parts
with \code{maxp} elements. It will not change results, but it is
necessary if your computer does not have enough RAM. Set to a lower value
if you still have problems.}

\item{verbose}{a logical. Set \code{FALSE} if you do not want to see any
information during the selection procedure.}

\item{...}{further arguments passed to \cite{read.big.matrix}.}
}
\value{
A numeric, a number of variables successfully written.
}
\description{
Transpose a big matrix and write to a file.
}
\examples{
\dontrun{
data <- matrix(sample(0:2, 20, replace=T), 2, 10)
rownames(data) <- c("X1", "X2")
write.table(data, "X.txt", col.names=FALSE)
X <- read.big.matrix("X.txt", sep=" ", type="char", has.row.names=TRUE)
# if it is possible, set type="char", reading will be quicker
transposeBigMatrix(X, sep=" ")
}

}

