% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lassosum2.R
\name{snp_lassosum2}
\alias{snp_lassosum2}
\title{lassosum2}
\usage{
snp_lassosum2(
  corr,
  df_beta,
  delta = c(0.001, 0.01, 0.1, 1),
  nlambda = 30,
  lambda.min.ratio = 0.01,
  dfmax = 2e+05,
  maxiter = 1000,
  tol = 1e-05,
  ind.corr = cols_along(corr),
  ncores = 1
)
}
\arguments{
\item{corr}{Sparse correlation matrix as an \link[bigsparser:SFBM-class]{SFBM}.
If \code{corr} is a dsCMatrix or a dgCMatrix, you can use \code{as_SFBM(corr)}.}

\item{df_beta}{A data frame with 3 columns:
\itemize{
\item \verb{$beta}: effect size estimates
\item \verb{$beta_se}: standard errors of effect size estimates
\item \verb{$n_eff}: either GWAS sample size(s) when estimating \code{beta} for a
continuous trait, or in the case of a binary trait, this is
\code{4 / (1 / n_control + 1 / n_case)}; in the case of a meta-analysis, you
should sum the effective sample sizes of each study instead of using the
total numbers of cases and controls, see \doi{10.1016/j.biopsych.2022.05.029};
when using a mixed model, the effective sample size needs to be adjusted
as well, see \doi{10.1016/j.xhgg.2022.100136}.
}}

\item{delta}{Vector of shrinkage parameters to try (L2-regularization).
Default is \code{c(0.001, 0.01, 0.1, 1)}.}

\item{nlambda}{Number of different lambdas to try (L1-regularization).
Default is \code{30}.}

\item{lambda.min.ratio}{Ratio between last and first lambdas to try.
Default is \code{0.01}.}

\item{dfmax}{Maximum number of non-zero effects in the model.
Default is \code{200e3}.}

\item{maxiter}{Maximum number of iterations before convergence.
Default is \code{1000}.}

\item{tol}{Tolerance parameter for assessing convergence.
Default is \code{1e-5}.}

\item{ind.corr}{Indices to "subset" \code{corr}, as if this was run with
\code{corr[ind.corr, ind.corr]} instead. No subsetting by default.}

\item{ncores}{Number of cores used. Default doesn't use parallelism.
You may use \code{\link[bigstatsr:reexports]{bigstatsr::nb_cores()}}.}
}
\value{
A matrix of effect sizes, one vector (column) for each row in
\verb{attr(<res>, "grid_param")}. Missing values are returned when strong
divergence is detected.
}
\description{
lassosum2
}
