% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/match-alleles.R
\name{snp_match}
\alias{snp_match}
\title{Match alleles}
\usage{
snp_match(
  sumstats,
  info_snp,
  strand_flip = TRUE,
  join_by_pos = TRUE,
  remove_dups = TRUE,
  match.min.prop = 0.2,
  return_flip_and_rev = FALSE
)
}
\arguments{
\item{sumstats}{A data frame with columns "chr", "pos", "a0", "a1" and "beta".}

\item{info_snp}{A data frame with columns "chr", "pos", "a0" and "a1".}

\item{strand_flip}{Whether to try to flip strand? (default is \code{TRUE})
If so, ambiguous alleles A/T and C/G are removed.}

\item{join_by_pos}{Whether to join by chromosome and position (default),
or instead by rsid.}

\item{remove_dups}{Whether to remove duplicates (same physical position)?
Default is \code{TRUE}.}

\item{match.min.prop}{Minimum proportion of variants in the smallest data
to be matched, otherwise stops with an error. Default is \verb{20\%}.}

\item{return_flip_and_rev}{Whether to return internal boolean variables
\code{"_FLIP_"} and \code{"_REV_"} (whether the alleles were flipped and/or reversed).
Default is \code{FALSE}. Values in column \verb{$beta} are multiplied by -1 for
variants with alleles reversed.}
}
\value{
A single data frame with matched variants. Values in column \verb{$beta}
are multiplied by -1 for variants with alleles reversed.
}
\description{
Match alleles between summary statistics and SNP information.
Match by ("chr", "a0", "a1") and ("pos" or "rsid"), accounting for possible
strand flips and reverse reference alleles (opposite effects).
}
\examples{
sumstats <- data.frame(
  chr = 1,
  pos = c(86303, 86331, 162463, 752566, 755890, 758144),
  a0 = c("T", "G", "C", "A", "T", "G"),
  a1 = c("G", "A", "T", "G", "A", "A"),
  beta = c(-1.868, 0.250, -0.671, 2.112, 0.239, 1.272),
  p = c(0.860, 0.346, 0.900, 0.456, 0.776, 0.383)
)

info_snp <- data.frame(
  id = c("rs2949417", "rs115209712", "rs143399298", "rs3094315", "rs3115858"),
  chr = 1,
  pos = c(86303, 86331, 162463, 752566, 755890),
  a0 = c("T", "A", "G", "A", "T"),
  a1 = c("G", "G", "A", "G", "A")
)

snp_match(sumstats, info_snp)
snp_match(sumstats, info_snp, strand_flip = FALSE)
}
\seealso{
\link{snp_modifyBuild}
}
