% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-save-infos.R
\name{snp_getSampleInfos}
\alias{snp_getSampleInfos}
\title{Get sample information}
\usage{
snp_getSampleInfos(x, df.or.files, col.family.ID = 1, col.sample.ID = 2,
  col.infos = -c(1, 2), pair.sep = "-_-", ...)
}
\arguments{
\item{x}{A \link[=bigSNP-class]{bigSNP}.}

\item{df.or.files}{Either
\itemize{
\item A \code{data.frame},
\item A character vector of file names where to find at the information you want.
You should have one column for family IDs and one for sample IDs.
}}

\item{col.family.ID}{Index of the column containing the
family IDs to match with those of the study. Default is the second one.}

\item{col.sample.ID}{Index of the column containing the
sample IDs to match with those of the study. Default is the first one.}

\item{col.infos}{Indices of the column containing the information you want.
Default is all but the first and the second columns.}

\item{pair.sep}{Separator used for concatenation family and sample IDs
in order to match easier. Default is \code{"-_-"}.}

\item{...}{Any additional parameter to pass to \link[data.table:fread]{fread}.
Particularly, option \code{header = FALSE} is sometimes needed.}
}
\value{
The requested information as a \code{data.frame}.
}
\description{
Get information of individuals by matching from an external file.
}
\examples{
test <- snp_attachExtdata()
# Just after reading
rle(test$fam$family.ID)
# Get populations clusters from external files
files <- system.file("extdata", paste0("cluster", 1:3), package = "bigsnpr")
data.table::fread(files[1])
# need header option
data.table::fread(files[1], header = FALSE)
infos <- snp_getSampleInfos(test, files, header = FALSE)
rle(infos[[1]])

}
\seealso{
\link{list.files}
}
