% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meteorological_variables.r
\name{air.density}
\alias{air.density}
\title{Air Density}
\usage{
air.density(Tair, pressure, constants = bigleaf.constants())
}
\arguments{
\item{Tair}{Air temperature (deg C)}

\item{pressure}{Atmospheric pressure (kPa)}

\item{constants}{Kelvin - conversion degC to Kelvin \cr
Rd - gas constant of dry air (J kg-1 K-1) \cr
kPa2Pa - conversion kilopascal (kPa) to pascal (Pa)}
}
\value{
\item{\eqn{\rho}}{air density (kg m-3)}
}
\description{
Air density of moist air from air temperature and pressure.
}
\details{
Air density (\eqn{\rho}) is calculated as:

  \deqn{\rho = pressure / (Rd * Tair)}
}
\examples{
# air density at 25degC and standard pressure (101.325kPa)
air.density(25,101.325)

}
\references{
Foken, T, 2008: Micrometeorology. Springer, Berlin, Germany.
}
