% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boundary_layer_conductance.r
\name{Gb.Su}
\alias{Gb.Su}
\title{Boundary Layer Conductance according to Su et al. 2001}
\usage{
Gb.Su(data, Tair = "Tair", pressure = "pressure", ustar = "ustar",
  wind = "wind", H = "H", zh, zr, d, Dl, fc = NULL, LAI = NULL,
  N = 2, Cd = 0.2, hs = 0.01, stab_formulation = c("Dyer_1970",
  "Businger_1971"), Sc = NULL, Sc_name = NULL,
  constants = bigleaf.constants())
}
\arguments{
\item{data}{Data.frame or matrix containing all required variables}

\item{Tair}{Air temperature (degC)}

\item{pressure}{Atmospheric pressure (kPa)}

\item{ustar}{Friction velocity (m s-1)}

\item{wind}{Wind speed (m s-1)}

\item{H}{Sensible heat flux (W m-2)}

\item{zh}{Canopy height (m)}

\item{zr}{Reference height (m)}

\item{d}{Zero-plane displacement height (-), can be calculated using \code{roughness.parameters}}

\item{Dl}{Leaf characteristic dimension (m)}

\item{fc}{Fractional vegetation cover [0-1] (if not provided, calculated from LAI)}

\item{LAI}{One-sided leaf area index (-)}

\item{N}{Number of leaf sides participating in heat exchange (defaults to 2)}

\item{Cd}{Foliage drag coefficient (-)}

\item{hs}{Roughness height of the soil (m)}

\item{stab_formulation}{Stability correction function used (If \code{stab_correction = TRUE}).
Either \code{"Dyer_1970"} or \code{"Businger_1971"}.}

\item{Sc}{Optional: Schmidt number of additional quantities to be calculated}

\item{Sc_name}{Optional: Name of the additional quantities, has to be of same length than 
\code{Sc_name}}

\item{constants}{Kelvin - conversion degree Celsius to Kelvin \cr
pressure0 - reference atmospheric pressure at sea level (Pa) \cr
Tair0 - reference air temperature (K) \cr
Sc_CO2 - Schmidt number for CO2 \cr 
Pr - Prandtl number (if \code{Sc} is provided)}
}
\value{
A data.frame with the following columns:
 \item{Gb_h}{Boundary layer conductance for heat transfer (m s-1)}
 \item{Rb_h}{Boundary layer resistance for heat transfer (s m-1)}
 \item{kB_h}{kB-1 parameter for heat transfer}
 \item{Gb_Sc_name}{Boundary layer conductance for \code{Sc_name} (m s-1). Only added if \code{Sc_name} and 
                   \code{Sc_name} are provided}
}
\description{
A physically based formulation for the canopy boundary layer conductance
             to heat transfer according to Su et al. 2001.
}
\details{
The formulation is based on the kB-1 model developed by Massman 1999. 
         Su et al. 2001 derived the following approximation:
          
           \deqn{kB-1 = (k Cd fc^2) / (4Ct ustar/u(zh)) + kBs-1(1 - fc)^2}
         
         If fc (fractional vegetation cover) is missing, it is estimated from LAI:

           \deqn{fc = 1 - exp(-LAI/2)}
         
         The wind speed at the top of the canopy is calculated using function
         \code{\link{wind.profile}}.
         
         Ct is the heat transfer coefficient of the leaf (Massman 1999):
         
           \deqn{Ct = Pr^-2/3 Reh^-1/2 N}
         
         where Pr is the Prandtl number (set to 0.71), and Reh is the Reynolds number for leaves:
         
           \deqn{Reh = Dl wind(zh) / v}
          
         kBs-1, the kB-1 value for bare soil surface, is calculated according 
         to Su et al. 2001:
         
           \deqn{kBs^-1 = 2.46(Re)^0.25 - ln(7.4)}
         
         Gb (=1/Rb) for water vapor and heat are assumed to be equal in this package.
         Gb for other quantities x is calculated as (Hicks et al. 1987):
 
           \deqn{Gb_x = Gb / (Sc_x / Pr)^0.67}
 
         where Sc_x is the Schmidt number of quantity x, and Pr is the Prandtl number (0.71).
}
\examples{
# Canopy boundary layer resistance (and kB-1 parameter) for a set of meteorological conditions,
# a leaf characteristic dimension of 1cm, and an LAI of 5
df <- data.frame(Tair=25,pressure=100,wind=c(3,4,5),ustar=c(0.5,0.6,0.65),H=c(200,230,250)) 
Gb.Su(data=df,zh=25,zr=40,d=17.5,Dl=0.01,LAI=5)

# the same meteorological conditions, but larger leaves
Gb.Su(data=df,zh=25,zr=40,d=17.5,Dl=0.1,LAI=5)

# same conditions, large leaves, and sparse canopy cover (LAI = 1.5)
Gb.Su(data=df,zh=25,zr=40,d=17.5,Dl=0.1,LAI=1.5)

}
\references{
Su, Z., Schmugge, T., Kustas, W. & Massman, W., 2001: An evaluation of
            two models for estimation of the roughness height for heat transfer between
            the land surface and the atmosphere. Journal of Applied Meteorology 40, 1933-1951.

            Massman, W., 1999: A model study of kB H- 1 for vegetated surfaces using
           'localized near-field' Lagrangian theory. Journal of Hydrology 223, 27-43.
           
            Hicks, B.B., Baldocchi, D.D., Meyers, T.P., Hosker, J.R., Matt, D.R., 1987:
            A preliminary multiple resistance routine for deriving dry deposition velocities
            from measured quantities. Water, Air, and Soil Pollution 36, 311-330.
}
\seealso{
\code{\link{Gb.Thom}}, \code{\link{Gb.Choudhury}}, \code{\link{aerodynamic.conductance}}
}
