% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bdm_main.R
\name{bdm.init}
\alias{bdm.init}
\title{Create \var{bdm} instance}
\usage{
bdm.init(dSet.name, dSet.data, labels = NULL, is.distance = F,
  check.duplicates = T)
}
\arguments{
\item{dSet.name}{The name given to the input dataset. This name will be used to automatically generate a name to save the output as an \var{.Rdata} file.}

\item{dSet.data}{A \var{data.frame} or \var{matrix} with raw input-data. The dataset must not have duplicated rows.}

\item{labels}{If available, labels can be included as a separate vector of length equal to \code{nrow(dSet.data)}. Label values are factorized as \code{as.numeric(as.factor(labels))}.}

\item{is.distance}{A logical value (FALSE by default). TRUE indicates that raw data is indeed a distance matrix.}

\item{check.duplicates}{If set to TRUE (default value) the dataset is checked for duplicated rows. Checking for duplicates in big datasets can take some time. If the dataset is known to have no duplicates disabling this option will save time.}
}
\value{
A \var{bdm} instance. A \var{bdm} instance is initially a list with a few elements (data and dataset information) to which new elements are added at each step of the mapping protocol.
}
\description{
Creates a \var{bdm} instance from
}
\examples{

# --- get a matrix with raw-data
mydata <- matrix(rnorm(10000, mean = 0, sd = 3),  ncol = 2)
mylabels <- apply(mydata, 1, function(row) round(sqrt(sum(row**2)), 0))
# --- create a \\var{bdm} instance with our raw-data matrix
mybdm <- bdm.init('mydataset', mydata, labels = mylabels)
str(mybdm)
}
