% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class041-bids_subject.R
\name{bids_subject}
\alias{bids_subject}
\alias{BIDSSubject}
\title{'BIDS' subject class}
\usage{
BIDSSubject(project, subject_code, ..., strict = "raw")

bids_subject(project, subject_code, ..., strict = "raw")
}
\arguments{
\item{project}{'BIDS' project instance, see \code{\link{BIDSProject}}, or
a path to the 'BIDS' project}

\item{subject_code}{character, subject code with or without the leading
\code{'sub-'}. The subject code, after trimming the leading entity key,
should not contain any additional dash (\code{'-'})}

\item{...}{passed to the constructor of \code{\link{BIDSProject}}, when
\code{project} is a character string}

\item{strict}{whether to check if the subject folders exist, can be
logical or characters; when \code{strict} is character strings, choices can
be \code{'raw'} (checking raw-data directory) and/or \code{'source'} (
for source-data directory); \code{strict=TRUE} is equivalent to checking
both; default is \code{'raw'}. There is no checks on derivatives.}
}
\value{
A 'BIDS' subject instance.
}
\description{
'BIDS' subject class
}
\examples{

# Run `download_bids_examples()` first
examples <- download_bids_examples(test = TRUE)
if(!isFALSE(examples)) {

  project_path <- file.path(examples, "ieeg_epilepsy_ecog")

  project <- BIDSProject(
    path = project_path,
    raw_data_relpath = ".",
    derivative_data_relpath = "derivatives"
  )


  subject <- BIDSSubject(project = project, subject_code = "ecog01",
                          strict = FALSE)

  storage_root <- resolve_bids_path(subject, storage = "raw")

  query_bids(subject, "ieeg")

}

}
\author{
Zhengjia Wang
}
