% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim.R
\name{sim}
\alias{sim}
\title{Simulation of OHLC Prices}
\usage{
sim(
  n = 10000,
  trades = 390,
  prob = 1,
  spread = 0.01,
  volatility = 0.03,
  jump = 0,
  drift = 0,
  askhigh = FALSE,
  bidlow = FALSE,
  units = "day"
)
}
\arguments{
\item{n}{the number of periods to simulate.}

\item{trades}{the number of trades per period.}

\item{prob}{the probability to observe a trade.}

\item{spread}{the percentage spread.}

\item{volatility}{the close-to-close volatility.}

\item{jump}{the close-to-open volatility.}

\item{drift}{the expected return per period.}

\item{askhigh}{if \code{TRUE}, returns the column \code{AskHigh} containing 1 if the High price is buyer initiated and 0 otherwise.}

\item{bidlow}{if \code{TRUE}, returns the column \code{BidLow} containing 1 if the Low price is seller initiated and 0 otherwise.}

\item{units}{the units of the time period. One of: \code{sec}, \code{min}, \code{hour}, \code{day}, \code{week}, \code{month}, \code{year}.}
}
\value{
Simulated OHLC prices.
}
\description{
This function performs simulations consisting of \code{n} periods (e.g., days) and where each period consists of a given number of \code{trades} (e.g., each minute).
For each trade, the true value of the stock price, \eqn{P_m}, is simulated as \eqn{P_m = P_{m-1}e^{\sigma x}}, where \eqn{\sigma} is the standard deviation per trade and \eqn{x} is a random draw from a unit normal distribution.
The standard deviation per period is equal to the \code{volatility} and the standard deviation per trade equals the \code{volatility} divided by the square root of the number of \code{trades}.
In each simulation, the trades are assumed to be observed with a given \code{probability}.
The bid (ask) for each trade is defined as \eqn{P_m} multiplied by one minus (plus) half the assumed bid-ask \code{spread} and we assume a 50\% chance that a bid (ask) is observed.
High and low prices equal the highest and lowest prices observed during the period.
Open and Close prices equal the first and the last price observed in the period.
If no trade is observed at time \eqn{t}, then the previous Close at time \eqn{t-1} is used as the Open, High, Low, and Close prices at time \eqn{t}.
The simulations may include close-to-open returns (e.g., overnight \code{jumps}).
}
\references{
Corwin, S. A., & Schultz, P. (2012). A simple way to estimate bid-ask spreads from daily high and low prices. The Journal of Finance, 67 (2), 719-760.
\doi{10.1111/j.1540-6261.2012.01729.x}

Abdi, F., & Ranaldo, A. (2017). A simple estimation of bid-ask spreads from daily close, high, and low prices. The Review of Financial Studies, 30 (12), 4437-4480.
\doi{10.1093/rfs/hhx084}

Ardia, D., Guidotti E., & Kroencke T. A. (2021). Efficient Estimation of Bid-Ask Spreads from Open, High, Low, and Close Prices. 
Available at SSRN: \url{https://www.ssrn.com/abstract=3892335}
}
