% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mse_heatmap.R
\name{mse_heatmap}
\alias{mse_heatmap}
\title{Make a heatmap of cell MSEs}
\usage{
mse_heatmap(x, ...)
}
\arguments{
\item{x}{An object of class \code{biclustermd}.}

\item{...}{Arguments to pass to \code{geom_tile()}}
}
\value{
A ggplot object.
}
\description{
Make a heatmap of cell MSEs
}
\examples{
data("synthetic")
bc <- biclustermd(synthetic, col_clusters = 3, row_clusters = 2,
                miss_val = mean(synthetic, na.rm = TRUE),
                miss_val_sd = sd(synthetic, na.rm = TRUE),
                col_min_num = 2, row_min_num = 2,
                col_num_to_move = 1, row_num_to_move = 1,
                max.iter = 10)

mse_heatmap(bc)

mse_heatmap(bc) + ggplot2::scale_fill_viridis_c()
}
