% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/histPlot.R
\name{histPlot}
\alias{histPlot}
\title{Plotting historical co-citation network}
\usage{
histPlot(histResults, size = F, labelsize = 1)
}
\arguments{
\item{histResults}{is an object of \code{class} "list" containing the following components:

\tabular{lll}{
NetMatrix \tab  \tab the historical co-citation network matrix\cr
Degree \tab       \tab the min degree of the network\cr
histData \tab      \tab the set of n most cited references}

is a network matrix obtained by the function \code{\link{biblioNetwork}}.}

\item{size}{is logical. If TRUE the point size of each vertex is proportional to its degree.}

\item{labelsize}{is an integer. It indicates the label size in the plot. Default is \code{labelsize=1}}
}
\value{
It is a network object of the class \code{igraph}.
}
\description{
\code{histPlot} plots a historical co-citation network.
}
\details{
The function \code{\link{histPlot}} can plot a historical co-citation network previously created by \code{\link{histNetwork}}.
}
\examples{
# EXAMPLE Co-citation network

library(igraph)
data(scientometrics)

histResults <- histNetwork(scientometrics, n = 20, sep = ";")

net <- histPlot(histResults, size = TRUE)

}
\seealso{
\code{\link{histNetwork}} to compute a historical co-citation network.

\code{\link{cocMatrix}} to compute a co-occurrence matrix.

\code{\link{biblioAnalysis}} to perform a bibliometric analysis.
}
