% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qbgumbel.R
\name{qbgumbel}
\alias{qbgumbel}
\title{Bimodal Gumbel: Quantile Function}
\usage{
qbgumbel(p, mu, sigma, delta, initial = -10, final = 10)
}
\arguments{
\item{p}{Probability.}

\item{mu}{First location parameter.}

\item{sigma}{Scale parameter.}

\item{delta}{Second location parameter.}

\item{initial}{Starting point of range in desired quantile.}

\item{final}{Starting point of range in desired quantile.}
}
\value{
Vector.
}
\description{
Bimodal Gumbel: Quantile Function
}
\examples{
# It is recommended to set up a pbgumbel
# graph to see the starting and ending
# range of the desired quantile.
curve(pbgumbel(x, mu = -2, sigma = 1, delta = -1), xlim = c(-5, 5))
(value <- qbgumbel(.25, mu = -2, sigma = 1, delta = -1, initial = -4, final = -2))
pbgumbel(value, mu = -2, sigma = 1, delta = -1)
}
