% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tune_temps.R
\name{tune_temperatures}
\alias{tune_temperatures}
\title{tune_temperatures}
\usage{
tune_temperatures(data, n_temps, temp_tune_iterations = 5000,
  n_draws = 2500, K = NULL, proposal_sds = NULL,
  sd_tune_iterations = 5000, theta_prior_params = c(0, 1),
  alpha_prior_params = c(1.5, 1.5, 0.25, 4), delta_prior_params = c(2,
  2, -5, 5), tau_prior_params = c(2, 2, -6, 6))
}
\arguments{
\item{data}{An integer matrix giving the response by each
respondent to each item}

\item{n_temps}{How many temperatures to make?}

\item{temp_tune_iterations}{How many iterations should the temperature
tuning algorithm run for each temperature? (default is 5000)}

\item{n_draws}{How many draws should be used to determine each temperature?
(specifying n_draws < temp_tune_iterations will result in an error;
default is 2500).}

\item{K}{(Optional) A numeric vector with an element for each item giving
the number of options for the item; if not provided, it is generated by
taking the number of unique options observed in the data}

\item{proposal_sds}{(Optional) A list of length four where is element is a
numeric vector giving standard deviations for the proposals;
the first element should be a numeric vector with a standard deviation
for the proposal for each respondent's theta parameter (the latent trait),
the second a vector with a standard deviation for each item's alpha
(discrimination) parameter, the third a vector with a standard deviation
for each item's delta (location) parameter, and the fourth a vector with
a standard deviation for each item's tau (option threshold) parameters.
If not given, the standard deviations are all set to 1.0 before any
tuning begins.}

\item{sd_tune_iterations}{A numeric vector of length one; if proposal
standard deviations are not given, this provides the number of
iterations to use to tune the proposals before the temperature finding
algorithm begins (default is 5000)}

\item{theta_prior_params}{A numeric vector of length two;
the mean and standard deviation of theta parameters' prior distribution
(where the theta parameters have a normal prior; the default is 0 and 1)}

\item{alpha_prior_params}{A numeric vector of length four;
the two shape parameters and a and b values for alpha parameters' prior
distribution (where the alpha parameters have a four parameter beta prior;
the default is 1.5, 1.5, 0.25, and 4)}

\item{delta_prior_params}{A numeric vector of length four;
the two shape parameters and a and b values for delta parameters' prior
distribution (where the delta parameters have a four parameter beta prior;
the default is 2, 2, -5, and 5)}

\item{tau_prior_params}{A numeric vector of length four;
the two shape parameters and a and b values for tau parameters' prior
distribution (where the tau parameters have a four parameter beta prior;
the default is 2, 2, -6, and 6)}
}
\value{
A numeric vector of temperatures
}
\description{
Find Optimal Temperatures for the GGUM MCMCMC Sampler
}
\details{
Atchadé, Roberts, and Rosenthal (2011) determine the optimal swap-acceptance
rate for Metropolis-coupled MCMC and provide an algorithm for building
optimal temperature schedules. We implement this algorithm in the context of
the GGUM to provide a temperature schedule that should result in
approximately 0.234 swap acceptance rate between adjacent chains.

Please see the vignette (via \code{vignette("bggum")}) for a full in-depth
practical guide to Bayesian estimation of GGUM parameters.
}
\examples{
## NOTE: This is a toy example just to demonstrate the function, which uses
## a small dataset and an unreasonably low number of sampling interations.
## For a longer practical guide on Bayesian estimation of GGUM parameters,
## please see the vignette ( via vignette("bggum") ).
## We'll simulate data to use for this example:
set.seed(123)
sim_data <- ggum_simulation(100, 10, 2)
## Now we can tune the temperature schedule:
## (for the purposes of example, we use 100 iterations,
## though in practice you would use much more)
temps <- tune_temperatures(data = sim_data$response_matrix, n_temps = 5,
                           temp_tune_iterations = 100, n_draws = 50,
                           sd_tune_iterations = 100)

}
\references{
Atchadé, Yves F., Gareth O. Roberts, and Jeffrey S. Rosenthal.
  2011.  \dQuote{Towards Optimal Scaling of Metropolis-Coupled Markov Chain
  Monte Carlo.} \emph{Statistics and Computing} 21(4): 555--68.
}
\seealso{
\code{\link{ggumMCMC}}, \code{\link{ggumMC3}}
}
