% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmc_misc.R
\name{InverseHDI}
\alias{InverseHDI}
\title{Compute Inverse HDI}
\usage{
InverseHDI(beta, shape1, shape2, credible.region = 0.95,
  tolerance = 0.00000001)
}
\arguments{
\item{beta}{density, distribution function, quantile function and random generation for the Beta distribution with parameters shape1 and shape2}

\item{shape1}{non-negative parameter of the Beta distribution.}

\item{shape2}{non-negative parameter of the Beta distribution.}

\item{credible.region}{summarize uncertainty by defining a region of most credible values (e.g., 95 percent of the distribution), Default: 0.95}

\item{tolerance}{the desired accuracy, Default: 1e-8}
}
\value{
Return HDI
}
\description{
Compute inverse cumulative density function of the distribution
}
\details{
values within the HDI have higher probability density than values outside the HDI, and the values inside the HDI have a total probability equal to the credible region (e.g., 95 percent).
}
\examples{
InverseHDI( qbeta , 554 , 149 )
# HDIlo HDIhi
# 0.758 0.818
}
\seealso{
\code{\link[stats]{Beta}},\code{\link[stats]{optimize}}
}
