% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynamicWhittle_prior_and_mcmc_params.R
\name{sim_tvarma12}
\alias{sim_tvarma12}
\title{simulate from the tvARMA(1,2) process for illustration}
\usage{
sim_tvarma12(
  len_d,
  dgp = NULL,
  ar_order = 1,
  ma_order = 2,
  a1 = NULL,
  b1 = NULL,
  b2 = NULL,
  innov_distribution = NULL,
  wn = NULL
)
}
\arguments{
\item{len_d}{a positive integer indicating the length of the simulated process.}

\item{dgp}{optional: the tv-ARMA models demonstrated in section 4.2 of Tang et al. (2023). Should be chosen from "LS1", "LS2" and "LS3". See section Details.}

\item{ar_order, ma_order, a1, b1, b2}{If dgp is not supplied, these arguments can be used to specify customized tv-ARMA
process (up to order(1,2)). See details.}

\item{innov_distribution}{optional: the distributions of innovation used in section 4.2.2 of Tang et al. (2023) . 
Should be chosen from "a", "b", "c". "a" denotes standard normal distribution, 
"b" indicates standardized Student-t distribution with degrees of freedom 4 and
"c" denotes standardized Pareto distribution with scale 1 and shape 4.}

\item{wn}{If innov_distribution is not specified, one may supply its own innovation sequence. Please make sure the length
of wn is at least the sum of len_d and the MA order of the process. If ma_order is specified, then MA order is exactly
ma_order. If dgp is specified, the MA order of "LS1", "LS2" and "LS3" can be found in section Details below.}
}
\value{
a numeric vector of length len_d simulated from the given process.
}
\description{
simulate from the tvARMA(1,2) process for illustration
}
\details{
This function simulates from the following time-varying Autoregressive Moving Average model with order (1,2):

\ifelse{html}{\out{<math>X<sub>t,T</sub> = a<sub>1</sub>(<sup>t</sup>&frasl;<sub>T</sub>) X<sub>t-1,T</sub> + w<sub>t</sub> + b<sub>1</sub>(<sup>t</sup>&frasl;<sub>T</sub>) w<sub>t-1</sub> + b<sub>2</sub>(<sup>t</sup>&frasl;<sub>T</sub>) w<sub>t-2</sub>, t=1,2,...,T,</math>}
}{\deqn{X_{t,T} = a_1(t/T)X_{t-1,T} + w_{t} + b_1(t/T) w_{t-1} + b_2(t/T) w_{t-2}, \quad t=1,2,\cdots,T,}}
where \eqn{T} is the length specified and \ifelse{html}{\out{{w<sub>t</sub>}}}{\eqn{\{w_t\}}} are 
a sequence of i.i.d. random variables with mean 0 and standard deviation 1.

For dgp = "LS1", it is a tvMA(2) process (MA order is 2) with

\ifelse{html}{
\out{<math>a<sub>1</sub>(u)=0, b<sub>1</sub>(u)=1.122(1-1.178sin(&pi;/2 u)), b<sub>2</sub>(u)=-0.81.
</math>}
}{\deqn{a_1(u)=0, b_1(u)= 1.122(1 - 1.178\sin(\pi/2 u)), b_2(u) = -0.81.}}
For dgp = "LS2", it is a tvMA(1) process (MA order is 1) with

\ifelse{html}{
\out{<math>a<sub>1</sub>(u)=0, b<sub>1</sub>(u)=1.1cos(1.5-cos(4&pi; u)), b<sub>2</sub>(u)=0.
</math>}
}{\deqn{a_1(u)=0, b_1(u)= 1.1\cos\left(1.5 - \cos\left(4\pi u \right) \right), b_2(u) = 0.}}
For dgp = "LS3", it is a tvAR(1) process (MA order is 0) with

\ifelse{html}{
\out{<math>a<sub>1</sub>(u)=1.2u-0.6, b<sub>1</sub>(u)=0, b<sub>2</sub>(u)=0.</math>}
}{\deqn{a_1(u)=1.2u-0.6, b_1(u)= 0, b_2(u) = 0.}}
}
\examples{
\dontrun{
sim_tvarma12(len_d = 1500, 
dgp = "LS2", 
innov_distribution = "a") # generate from LS2a

sim_tvarma12(len_d = 1500, 
dgp = "LS2", 
wn = rnorm(1502)) # again, generate from LS2a

sim_tvarma12(len_d = 1500, 
ar_order = 0, 
ma_order = 1, 
b1 = function(u){1.1*cos(1.5 - cos(4*pi*u))}, 
innov_distribution = "a") # again, generate from LS2a

sim_tvarma12(len_d = 1500, 
ar_order = 0, 
ma_order = 1, 
b1 = function(u){1.1*cos(1.5 - cos(4*pi*u))}, 
wn = rnorm(1502)) # again, generate from LS2a
}
}
\references{
Tang et al. (2023)
\emph{Bayesian nonparametric spectral analysis of locally stationary processes}
ArXiv preprint
<arXiv:2303.11561>
}
