% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arma.R
\name{pacf_to_ar}
\alias{pacf_to_ar}
\title{Convert partial autocorrelation coefficients to AR coefficients.}
\usage{
pacf_to_ar(pacf)
}
\arguments{
\item{pacf}{numeric vector of partial autocorrelations in (-1,1)}
}
\value{
numeric vector of autoregressive model coefficients
}
\description{
Convert partial autocorrelation coefficients to AR coefficients.
}
\details{
See Section 2 in Kirch et al (2018) or Section III in Barndorff-Nielsen and Schou (1973) for further details
}
\references{
C. Kirch et al
Supplemental material of
\emph{Beyond Whittle: Nonparametric Correction of a Parametric Likelihood With a Focus on Bayesian Time Series Analysis}
Bayesian Analysis
<doi:10.1214/18-BA1126SUPP>

O. Barndorff-Nielsen and G. Schou
On the parametrization of autoregressive models by partial autocorrelations
Journal of Multivariate Analysis (3),408-419
<doi:10.1016/0047-259X(73)90030-4>
}
\seealso{
\link[stats]{acf2AR}, \link[stats]{ARMAacf}
}
