% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classification.R
\name{mdo}
\alias{mdo}
\title{Calculate McDonald's Omega reliability-coefficient from supplied variables.}
\usage{
mdo(x, fit = FALSE)
}
\arguments{
\item{x}{A data-frame or matrix of numerical values where rows represent respondents, and columns represent items.}

\item{fit}{Logical. Default is \code{FALSE}. If \code{TRUE}, the output changes from a vector containing the Omega reliability-estimate to a list containing additional detailed information concerning the fitted factor model.}
}
\value{
If \code{fit = FALSE}, A vector of length 1 containing the estimated McDonalds's Omega reliability-coefficient for the sum-score of the supplied variables. If \code{fit = TRUE}, a list containing the Omega-coefficient reliability-estimate as the first entry, followed by the goodness-of-fit index (GFI), a two-row matrix containing the estimated factor-loadings and error-variances, and the observed and fitted covariance-matrices and the discrepancy matrix.
}
\description{
Calculates McDonalds's Omega reliability-coefficient of the sum-score from the Spearman one-factor model using the procedure outlined in McDonald (1999).
}
\note{
Missing values are treated by passing \code{na.rm = TRUE} to the \code{var} function call and \code{use = "pairwise.complete.obs"} to the \code{cov} function call.

The function terminates with an error if there are negative covariance-matrix entries.
}
\examples{
# Generate some fictional data.
set.seed(1234)
rawdata <- matrix(rnorm(500), ncol = 5)
common <- rnorm(100)
rawdata <- apply(rawdata, 2, function(x) {x + common})

# To estimate McDonald's Omega from this data:
mdo(rawdata)

# To retrieve additional information such as the GFI fit-index and model-
# parameter estimates:
mdo(rawdata, fit = TRUE)
}
\references{
McDonald, R. P. (1999). Test Theory: A Unified Treatment. Routledge.
}
